"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.METRIC_TYPE = void 0;
Object.defineProperty(exports, "createApplicationUsageMetric", {
  enumerable: true,
  get: function () {
    return _application_usage.createApplicationUsageMetric;
  }
});
Object.defineProperty(exports, "createUiCounterMetric", {
  enumerable: true,
  get: function () {
    return _ui_counter.createUiCounterMetric;
  }
});
Object.defineProperty(exports, "trackUsageAgent", {
  enumerable: true,
  get: function () {
    return _user_agent.trackUsageAgent;
  }
});
var _ui_counter = require("./ui_counter");
var _user_agent = require("./user_agent");
var _application_usage = require("./application_usage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Export types separately to the actual run-time objects
let METRIC_TYPE = exports.METRIC_TYPE = /*#__PURE__*/function (METRIC_TYPE) {
  METRIC_TYPE["COUNT"] = "count";
  METRIC_TYPE["LOADED"] = "loaded";
  METRIC_TYPE["CLICK"] = "click";
  METRIC_TYPE["USER_AGENT"] = "user_agent";
  METRIC_TYPE["APPLICATION_USAGE"] = "application_usage";
  return METRIC_TYPE;
}({});