"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertFieldMap = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const alertFieldMap = exports.alertFieldMap = {
  [_ruleDataUtils.ALERT_ACTION_GROUP]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_CASE_IDS]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_DURATION]: {
    type: 'long',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_END]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_FLAPPING]: {
    type: 'boolean',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_FLAPPING_HISTORY]: {
    type: 'boolean',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_CONSECUTIVE_MATCHES]: {
    type: 'long',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_INSTANCE_ID]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_LAST_DETECTED]: {
    type: 'date',
    required: false,
    array: false
  },
  [_ruleDataUtils.ALERT_PREVIOUS_ACTION_GROUP]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_REASON]: {
    type: 'keyword',
    array: false,
    required: false,
    multi_fields: [{
      flat_name: `${_ruleDataUtils.ALERT_REASON}.text`,
      name: 'text',
      type: 'match_only_text'
    }]
  },
  [_ruleDataUtils.ALERT_RULE_CATEGORY]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_RULE_CONSUMER]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_RULE_EXECUTION_TIMESTAMP]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_NAME]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_RULE_PARAMETERS]: {
    array: false,
    type: 'flattened',
    ignore_above: 4096,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_PRODUCER]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_RULE_REVISION]: {
    type: 'long',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_RULE_TAGS]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_RULE_TYPE_ID]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_RULE_UUID]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_SEVERITY_IMPROVING]: {
    type: 'boolean',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_START]: {
    type: 'date',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_STATUS]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_TIME_RANGE]: {
    type: 'date_range',
    format: 'epoch_millis||strict_date_optional_time',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_URL]: {
    type: 'keyword',
    array: false,
    index: false,
    required: false,
    ignore_above: 2048
  },
  [_ruleDataUtils.ALERT_UUID]: {
    type: 'keyword',
    array: false,
    required: true
  },
  [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.ALERT_WORKFLOW_TAGS]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.EVENT_ACTION]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.EVENT_KIND]: {
    type: 'keyword',
    array: false,
    required: false
  },
  [_ruleDataUtils.SPACE_IDS]: {
    type: 'keyword',
    array: true,
    required: true
  },
  [_ruleDataUtils.TAGS]: {
    type: 'keyword',
    array: true,
    required: false
  },
  [_ruleDataUtils.TIMESTAMP]: {
    type: 'date',
    required: true,
    array: false
  },
  [_ruleDataUtils.VERSION]: {
    type: 'version',
    array: false,
    required: false
  }
};