"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleLastRunOutcomeValues = exports.RuleExecutionStatusWarningReasons = exports.RuleExecutionStatusValues = exports.RuleExecutionStatusErrorReasons = exports.ISO_WEEKDAYS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ISO_WEEKDAYS = exports.ISO_WEEKDAYS = [1, 2, 3, 4, 5, 6, 7];
// for the `typeof ThingValues[number]` types below, become string types that
// only accept the values in the associated string arrays
const RuleExecutionStatusValues = exports.RuleExecutionStatusValues = ['ok', 'active', 'error', 'pending', 'unknown', 'warning'];
const RuleLastRunOutcomeValues = exports.RuleLastRunOutcomeValues = ['succeeded', 'warning', 'failed'];
let RuleExecutionStatusErrorReasons = exports.RuleExecutionStatusErrorReasons = /*#__PURE__*/function (RuleExecutionStatusErrorReasons) {
  RuleExecutionStatusErrorReasons["Read"] = "read";
  RuleExecutionStatusErrorReasons["Decrypt"] = "decrypt";
  RuleExecutionStatusErrorReasons["Execute"] = "execute";
  RuleExecutionStatusErrorReasons["Unknown"] = "unknown";
  RuleExecutionStatusErrorReasons["License"] = "license";
  RuleExecutionStatusErrorReasons["Timeout"] = "timeout";
  RuleExecutionStatusErrorReasons["Disabled"] = "disabled";
  RuleExecutionStatusErrorReasons["Validate"] = "validate";
  return RuleExecutionStatusErrorReasons;
}({});
let RuleExecutionStatusWarningReasons = exports.RuleExecutionStatusWarningReasons = /*#__PURE__*/function (RuleExecutionStatusWarningReasons) {
  RuleExecutionStatusWarningReasons["MAX_EXECUTABLE_ACTIONS"] = "maxExecutableActions";
  RuleExecutionStatusWarningReasons["MAX_ALERTS"] = "maxAlerts";
  RuleExecutionStatusWarningReasons["MAX_QUEUED_ACTIONS"] = "maxQueuedActions";
  return RuleExecutionStatusWarningReasons;
}({}); // Type signature of has to be repeated here to avoid issues with SavedObject compatibility
// RuleSnooze = RuleSnoozeSchedule[] throws typescript errors across the whole lib