"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleTypeRunner = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _server = require("@kbn/task-manager-plugin/server");
var _task_running = require("@kbn/task-manager-plugin/server/task_running");
var _lib = require("../lib");
var _get_time_range = require("../lib/get_time_range");
var _types = require("../types");
var _task_runner_timer = require("./task_runner_timer");
var _lib2 = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleTypeRunner {
  constructor(options) {
    (0, _defineProperty2.default)(this, "cancelled", false);
    this.options = options;
  }
  cancelRun() {
    this.cancelled = true;
  }
  async run({
    context,
    alertsClient,
    executionId,
    executorServices,
    maintenanceWindows = [],
    maintenanceWindowsWithoutScopedQueryIds = [],
    rule,
    ruleType,
    startedAt,
    state,
    validatedParams
  }) {
    var _this$options$task$st;
    const {
      alertTypeId: ruleTypeId,
      consumer,
      schedule,
      throttle = null,
      notifyWhen = null,
      name,
      tags,
      createdBy,
      updatedBy,
      createdAt,
      updatedAt,
      enabled,
      actions,
      muteAll,
      revision,
      snoozeSchedule,
      alertDelay
    } = rule;
    const {
      alertTypeState: ruleTypeState = {},
      previousStartedAt
    } = state;
    const startedAtOverridden = ((_this$options$task$st = this.options.task.startedAt) === null || _this$options$task$st === void 0 ? void 0 : _this$options$task$st.toISOString()) !== startedAt.toISOString();
    const {
      updatedRuleTypeState,
      error,
      stackTrace
    } = await this.options.timer.runWithTimer(_task_runner_timer.TaskRunnerTimerSpan.RuleTypeRun, async () => {
      var _executorResult;
      const checkHasReachedAlertLimit = () => {
        const reachedLimit = alertsClient.hasReachedAlertLimit() || false;
        if (reachedLimit) {
          this.options.logger.warn(`rule execution generated greater than ${this.options.context.maxAlerts} alerts: ${context.ruleLogPrefix}`);
          context.ruleRunMetricsStore.setHasReachedAlertLimit(true);
        }
        return reachedLimit;
      };
      let executorResult;
      try {
        var _context$namespace;
        const ctx = {
          type: 'alert',
          name: `execute ${ruleTypeId}`,
          id: context.ruleId,
          description: `execute [${ruleTypeId}] with name [${name}] in [${(_context$namespace = context.namespace) !== null && _context$namespace !== void 0 ? _context$namespace : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING}] namespace`
        };
        executorResult = await (0, _lib2.withAlertingSpan)('rule-type-executor', () => this.options.context.executionContext.withContext(ctx, () => {
          var _context$flappingSett;
          return ruleType.executor({
            executionId,
            services: {
              alertFactory: alertsClient.factory(),
              alertsClient: alertsClient.client(),
              dataViews: executorServices.dataViews,
              ruleMonitoringService: executorServices.ruleMonitoringService,
              ruleResultService: executorServices.ruleResultService,
              savedObjectsClient: executorServices.savedObjectsClient,
              scopedClusterClient: executorServices.wrappedScopedClusterClient.client(),
              searchSourceClient: executorServices.wrappedSearchSourceClient.searchSourceClient,
              share: this.options.context.share,
              shouldStopExecution: () => this.cancelled,
              shouldWriteAlerts: () => this.shouldLogAndScheduleActionsForAlerts(ruleType.cancelAlertsOnRuleTimeout),
              uiSettingsClient: executorServices.uiSettingsClient
            },
            params: validatedParams,
            state: ruleTypeState,
            startedAtOverridden,
            startedAt,
            previousStartedAt: previousStartedAt ? new Date(previousStartedAt) : null,
            spaceId: context.spaceId,
            namespace: context.namespace,
            rule: {
              id: context.ruleId,
              name,
              tags,
              consumer,
              producer: ruleType.producer,
              revision,
              ruleTypeId,
              ruleTypeName: ruleType.name,
              enabled,
              schedule,
              actions,
              createdBy,
              updatedBy,
              createdAt,
              updatedAt,
              throttle,
              notifyWhen,
              muteAll,
              snoozeSchedule,
              alertDelay
            },
            logger: this.options.logger,
            flappingSettings: (_context$flappingSett = context.flappingSettings) !== null && _context$flappingSett !== void 0 ? _context$flappingSett : _types.DEFAULT_FLAPPING_SETTINGS,
            // passed in so the rule registry knows about maintenance windows
            ...(maintenanceWindowsWithoutScopedQueryIds.length ? {
              maintenanceWindowIds: maintenanceWindowsWithoutScopedQueryIds
            } : {}),
            getTimeRange: timeWindow => (0, _get_time_range.getTimeRange)({
              logger: this.options.logger,
              window: timeWindow,
              ...(context.queryDelaySec ? {
                queryDelay: context.queryDelaySec
              } : {}),
              ...(startedAtOverridden ? {
                forceNow: startedAt
              } : {})
            })
          });
        }));
        // Rule type execution has successfully completed
        // Check that the rule type either never requested the max alerts limit
        // or requested it and then reported back whether it exceeded the limit
        // If neither of these apply, this check will throw an error
        // These errors should show up during rule type development
        alertsClient.checkLimitUsage();
      } catch (err) {
        // Check if this error is due to reaching the alert limit
        if (!checkHasReachedAlertLimit()) {
          context.alertingEventLogger.setExecutionFailed(`rule execution failure: ${context.ruleLogPrefix}`, err.message);
          return {
            error: (0, _server.createTaskRunError)(new _lib.ErrorWithReason(_types.RuleExecutionStatusErrorReasons.Execute, err), (0, _task_running.getErrorSource)(err) || _server.TaskErrorSource.FRAMEWORK),
            stackTrace: {
              message: err,
              stackTrace: err.stack
            }
          };
        }
      }

      // Check if the rule type has reported that it reached the alert limit
      checkHasReachedAlertLimit();
      context.alertingEventLogger.setExecutionSucceeded(`rule executed: ${context.ruleLogPrefix}`);
      context.ruleRunMetricsStore.setSearchMetrics([executorServices.wrappedScopedClusterClient.getMetrics(), executorServices.wrappedSearchSourceClient.getMetrics()]);
      return {
        updatedRuleTypeState: ((_executorResult = executorResult) === null || _executorResult === void 0 ? void 0 : _executorResult.state) || undefined
      };
    });
    if (error) {
      return {
        state: undefined,
        error,
        stackTrace
      };
    }
    await (0, _lib2.withAlertingSpan)('alerting:process-alerts', () => this.options.timer.runWithTimer(_task_runner_timer.TaskRunnerTimerSpan.ProcessAlerts, async () => {
      var _context$flappingSett2, _alertDelay$active;
      alertsClient.processAlerts({
        flappingSettings: (_context$flappingSett2 = context.flappingSettings) !== null && _context$flappingSett2 !== void 0 ? _context$flappingSett2 : _types.DEFAULT_FLAPPING_SETTINGS,
        maintenanceWindowIds: maintenanceWindowsWithoutScopedQueryIds,
        alertDelay: (_alertDelay$active = alertDelay === null || alertDelay === void 0 ? void 0 : alertDelay.active) !== null && _alertDelay$active !== void 0 ? _alertDelay$active : 0,
        ruleRunMetricsStore: context.ruleRunMetricsStore
      });
    }));
    await (0, _lib2.withAlertingSpan)('alerting:index-alerts-as-data', () => this.options.timer.runWithTimer(_task_runner_timer.TaskRunnerTimerSpan.PersistAlerts, async () => {
      const updateAlertsMaintenanceWindowResult = await alertsClient.persistAlerts(maintenanceWindows);

      // Set the event log MW ids again, this time including the ids that matched alerts with
      // scoped query
      if (updateAlertsMaintenanceWindowResult !== null && updateAlertsMaintenanceWindowResult !== void 0 && updateAlertsMaintenanceWindowResult.maintenanceWindowIds && (updateAlertsMaintenanceWindowResult === null || updateAlertsMaintenanceWindowResult === void 0 ? void 0 : updateAlertsMaintenanceWindowResult.maintenanceWindowIds.length) > 0) {
        context.alertingEventLogger.setMaintenanceWindowIds(updateAlertsMaintenanceWindowResult.maintenanceWindowIds);
      }
    }));
    alertsClient.logAlerts({
      eventLogger: context.alertingEventLogger,
      ruleRunMetricsStore: context.ruleRunMetricsStore,
      shouldLogAlerts: this.shouldLogAndScheduleActionsForAlerts(ruleType.cancelAlertsOnRuleTimeout)
    });
    return {
      state: updatedRuleTypeState
    };
  }
  shouldLogAndScheduleActionsForAlerts(ruleTypeShouldCancel) {
    // if execution hasn't been cancelled, return true
    if (!this.cancelled) {
      return true;
    }

    // if execution has been cancelled, return true if EITHER alerting config or rule type indicate to proceed with scheduling actions
    return !this.options.context.cancelAlertsOnRuleTimeout || !ruleTypeShouldCancel;
  }
}
exports.RuleTypeRunner = RuleTypeRunner;