"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaintenanceWindows = exports.filterMaintenanceWindowsIds = exports.filterMaintenanceWindows = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterMaintenanceWindows = ({
  maintenanceWindows,
  withScopedQuery
}) => {
  const filteredMaintenanceWindows = maintenanceWindows.filter(({
    scopedQuery
  }) => {
    if (withScopedQuery && scopedQuery) {
      return true;
    } else if (!withScopedQuery && !scopedQuery) {
      return true;
    }
    return false;
  });
  return filteredMaintenanceWindows;
};
exports.filterMaintenanceWindows = filterMaintenanceWindows;
const filterMaintenanceWindowsIds = ({
  maintenanceWindows,
  withScopedQuery
}) => {
  const filteredMaintenanceWindows = filterMaintenanceWindows({
    maintenanceWindows,
    withScopedQuery
  });
  return filteredMaintenanceWindows.map(({
    id
  }) => id);
};
exports.filterMaintenanceWindowsIds = filterMaintenanceWindowsIds;
const getMaintenanceWindows = async opts => {
  const {
    context,
    fakeRequest,
    logger,
    ruleTypeId,
    ruleId,
    ruleTypeCategory
  } = opts;
  const maintenanceWindowClient = context.getMaintenanceWindowClientWithRequest(fakeRequest);
  let activeMaintenanceWindows = [];
  try {
    activeMaintenanceWindows = await maintenanceWindowClient.getActiveMaintenanceWindows();
  } catch (err) {
    logger.error(`error getting active maintenance window for ${ruleTypeId}:${ruleId} ${err.message}`);
  }
  const maintenanceWindows = activeMaintenanceWindows.filter(({
    categoryIds
  }) => {
    // If category IDs array doesn't exist: allow all
    if (!Array.isArray(categoryIds)) {
      return true;
    }
    // If category IDs array exist: check category
    if (categoryIds.includes(ruleTypeCategory)) {
      return true;
    }
    return false;
  });
  return maintenanceWindows;
};
exports.getMaintenanceWindows = getMaintenanceWindows;