"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutorServices = void 0;
var _ = require("..");
var _lib = require("../lib");
var _wrap_scoped_cluster_client = require("../lib/wrap_scoped_cluster_client");
var _wrap_search_source_client = require("../lib/wrap_search_source_client");
var _lib2 = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExecutorServices = async opts => {
  const {
    context,
    abortController,
    fakeRequest,
    logger,
    ruleData,
    ruleTaskTimeout
  } = opts;
  const wrappedClientOptions = {
    rule: ruleData,
    logger,
    abortController,
    // Set the ES request timeout to the rule task timeout
    requestTimeout: (0, _lib.getEsRequestTimeout)(logger, ruleTaskTimeout)
  };
  const scopedClusterClient = context.elasticsearch.client.asScoped(fakeRequest);
  const wrappedScopedClusterClient = (0, _wrap_scoped_cluster_client.createWrappedScopedClusterClientFactory)({
    ...wrappedClientOptions,
    scopedClusterClient
  });
  const searchSourceClient = await (0, _lib2.withAlertingSpan)('alerting:get-search-source-client', () => context.data.search.searchSource.asScoped(fakeRequest));
  const wrappedSearchSourceClient = (0, _wrap_search_source_client.wrapSearchSourceClient)({
    ...wrappedClientOptions,
    searchSourceClient
  });
  const savedObjectsClient = context.savedObjects.getScopedClient(fakeRequest, {
    includedHiddenTypes: [_.RULE_SAVED_OBJECT_TYPE, 'action']
  });
  const dataViews = await await (0, _lib2.withAlertingSpan)('alerting:get-data-views-factory', () => context.dataViews.dataViewsServiceFactory(savedObjectsClient, scopedClusterClient.asInternalUser));
  const uiSettingsClient = context.uiSettings.asScopedToClient(savedObjectsClient);
  return {
    dataViews,
    ruleMonitoringService: opts.ruleMonitoringService.getLastRunMetricsSetters(),
    ruleResultService: opts.ruleResultService.getLastRunSetters(),
    savedObjectsClient,
    uiSettingsClient,
    wrappedScopedClusterClient,
    wrappedSearchSourceClient
  };
};
exports.getExecutorServices = getExecutorServices;