"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partiallyUpdateRule = partiallyUpdateRule;
var _lodash = require("lodash");
var _server = require("@kbn/core/server");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// We have calling code that references both RawRule and RuleAttributes,
// so we need to support both of these types (they are effectively the same)

// typed this way so we can send a SavedObjectClient or SavedObjectRepository

// direct, partial update to a rule saved object via scoped SavedObjectsClient
// using namespace set in the client
async function partiallyUpdateRule(savedObjectsClient, id, attributes, options = {}) {
  // ensure we only have the valid attributes that are not encrypted and are excluded from AAD
  const attributeUpdates = (0, _lodash.omit)(attributes, [..._.RuleAttributesToEncrypt, ..._.RuleAttributesIncludedInAAD]);
  const updateOptions = (0, _lodash.pick)(options, 'namespace', 'version', 'refresh');
  try {
    await savedObjectsClient.update(_.RULE_SAVED_OBJECT_TYPE, id, attributeUpdates, updateOptions);
  } catch (err) {
    if (options !== null && options !== void 0 && options.ignore404 && _server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
      return;
    }
    throw err;
  }
}