"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFlappingSettingsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _lib = require("./lib");
var _types = require("../types");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean(),
  look_back_window: _configSchema.schema.number(),
  status_change_threshold: _configSchema.schema.number()
});
const rewriteQueryReq = ({
  look_back_window: lookBackWindow,
  status_change_threshold: statusChangeThreshold,
  ...rest
}) => ({
  ...rest,
  lookBackWindow,
  statusChangeThreshold
});
const rewriteBodyRes = ({
  lookBackWindow,
  statusChangeThreshold,
  createdBy,
  updatedBy,
  createdAt,
  updatedAt,
  ...rest
}) => ({
  ...rest,
  look_back_window: lookBackWindow,
  status_change_threshold: statusChangeThreshold,
  created_by: createdBy,
  updated_by: updatedBy,
  created_at: createdAt,
  updated_at: updatedAt
});
const updateFlappingSettingsRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_flapping`,
    validate: {
      body: bodySchema
    },
    options: {
      tags: [`access:${_common.API_PRIVILEGES.WRITE_FLAPPING_SETTINGS}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesSettingsClient = (await context.alerting).getRulesSettingsClient();
    const updatedFlappingSettings = await rulesSettingsClient.flapping().update(rewriteQueryReq(req.body));
    return res.ok({
      body: updatedFlappingSettings && rewriteBodyRes(updatedFlappingSettings)
    });
  })));
};
exports.updateFlappingSettingsRoute = updateFlappingSettingsRoute;