"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateQueryDelaySettingsRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _common = require("../../../../../common");
var _update = require("../../../../../common/routes/rules_settings/apis/update");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateQueryDelaySettingsRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_query_delay`,
    validate: {
      body: _update.updateQueryDelaySettingsBodySchemaV1
    },
    options: {
      tags: [`access:${_common.API_PRIVILEGES.WRITE_QUERY_DELAY_SETTINGS}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesSettingsClient = (await context.alerting).getRulesSettingsClient();
    const body = req.body;
    const updatedQueryDelaySettings = await rulesSettingsClient.queryDelay().update(body);
    const response = (0, _transforms.transformQueryDelaySettingsToResponseV1)(updatedQueryDelaySettings);
    return res.ok(response);
  })));
};
exports.updateQueryDelaySettingsRoute = updateQueryDelaySettingsRoute;