"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRuleRoute = void 0;
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _update = require("../../../../../common/routes/rule/apis/update");
var _types = require("../../../../types");
var _transforms = require("./transforms");
var _transforms2 = require("../../transforms");
var _validation = require("../../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateRuleRoute = (router, licenseState) => {
  router.put({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}`,
    options: {
      access: 'public',
      summary: `Update a rule`,
      tags: ['oas-tag:alerting']
    },
    validate: {
      body: _update.updateBodySchemaV1,
      params: _update.updateParamsSchemaV1
    }
  }, (0, _lib2.handleDisabledApiKeysError)(router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const actionsClient = (await context.actions).getActionsClient();

    // Assert versioned inputs
    const updateRuleData = req.body;
    const updateRuleParams = req.params;
    try {
      /**
       * Throws an error if the group is not defined in default actions
       */
      const {
        actions: allActions = []
      } = updateRuleData;
      (0, _validation.validateRequiredGroupInDefaultActionsV1)({
        actions: allActions,
        isSystemAction: connectorId => actionsClient.isSystemAction(connectorId)
      });
      const actions = allActions.filter(action => !actionsClient.isSystemAction(action.id));
      const systemActions = allActions.filter(action => actionsClient.isSystemAction(action.id));

      // TODO (http-versioning): Remove this cast, this enables us to move forward
      // without fixing all of other solution types
      const updatedRule = await rulesClient.update({
        id: updateRuleParams.id,
        data: (0, _transforms.transformUpdateBodyV1)({
          updateBody: updateRuleData,
          actions,
          systemActions
        })
      });

      // Assert versioned response type
      const response = {
        body: (0, _transforms2.transformRuleToRuleResponseV1)(updatedRule)
      };
      return res.ok(response);
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  }))));
};
exports.updateRuleRoute = updateRuleRoute;