"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveRuleRoute = void 0;
var _resolve = require("../../../../../common/routes/rule/apis/resolve");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolveRuleRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rule/{id}/_resolve`,
    validate: {
      params: _resolve.resolveParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;
    const {
      id
    } = params;
    // TODO (http-versioning): Remove this cast, this enables us to move forward
    // without fixing all of other solution types
    const rule = await rulesClient.resolve({
      id,
      includeSnoozeData: true
    });
    const response = {
      body: (0, _transforms.transformResolveResponseV1)(rule)
    };
    return res.ok(response);
  })));
};
exports.resolveRuleRoute = resolveRuleRoute;