"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleRoute = exports.getInternalRuleRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("../../transforms");
var _get = require("../../../../../common/routes/rule/apis/get");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildGetRuleRoute = ({
  licenseState,
  path,
  router,
  excludeFromPublicApi = false,
  options
}) => {
  router.get({
    path,
    options,
    validate: {
      params: _get.getRuleRequestParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;

    // TODO (http-versioning): Remove this cast, this enables us to move forward
    // without fixing all of other solution types
    const rule = await rulesClient.get({
      id: params.id,
      excludeFromPublicApi,
      includeSnoozeData: true
    });
    const response = {
      body: (0, _transforms.transformRuleToRuleResponseV1)(rule)
    };
    return res.ok(response);
  })));
};
const getRuleRoute = (router, licenseState) => buildGetRuleRoute({
  excludeFromPublicApi: true,
  licenseState,
  path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}`,
  router,
  options: {
    access: 'public',
    summary: `Get rule details`,
    tags: ['oas-tag:alerting']
  }
});
exports.getRuleRoute = getRuleRoute;
const getInternalRuleRoute = (router, licenseState) => buildGetRuleRoute({
  excludeFromPublicApi: false,
  licenseState,
  path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rule/{id}`,
  router
});
exports.getInternalRuleRoute = getInternalRuleRoute;