"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformPartialRule = exports.transformFindRulesResponse = void 0;
var _transforms = require("../../../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformPartialRule = (rule, fields) => {
  var _rule$executionStatus, _rule$isSnoozedUntil, _rule$nextRun;
  const ruleResponse = {
    ...(rule.id !== undefined ? {
      id: rule.id
    } : {}),
    ...(rule.enabled !== undefined ? {
      enabled: rule.enabled
    } : {}),
    ...(rule.name !== undefined ? {
      name: rule.name
    } : {}),
    ...(rule.tags ? {
      tags: rule.tags
    } : {}),
    ...(rule.alertTypeId !== undefined ? {
      rule_type_id: rule.alertTypeId
    } : {}),
    ...(rule.consumer !== undefined ? {
      consumer: rule.consumer
    } : {}),
    ...(rule.schedule ? {
      schedule: rule.schedule
    } : {}),
    ...(rule.actions || rule.systemActions ? {
      actions: (0, _transforms.transformRuleActionsV1)(rule.actions || [], rule.systemActions || [])
    } : {}),
    ...(rule.params ? {
      params: rule.params
    } : {}),
    ...(rule.mapped_params ? {
      mapped_params: rule.mapped_params
    } : {}),
    ...(rule.scheduledTaskId !== undefined ? {
      scheduled_task_id: rule.scheduledTaskId
    } : {}),
    ...(rule.createdBy !== undefined ? {
      created_by: rule.createdBy
    } : {}),
    ...(rule.updatedBy !== undefined ? {
      updated_by: rule.updatedBy
    } : {}),
    ...(rule.createdAt ? {
      created_at: rule.createdAt.toISOString()
    } : {}),
    ...(rule.updatedAt ? {
      updated_at: rule.updatedAt.toISOString()
    } : {}),
    ...(rule.apiKeyOwner !== undefined ? {
      api_key_owner: rule.apiKeyOwner
    } : {}),
    ...(rule.apiKeyCreatedByUser !== undefined ? {
      api_key_created_by_user: rule.apiKeyCreatedByUser
    } : {}),
    ...(rule.throttle !== undefined ? {
      throttle: rule.throttle
    } : {}),
    ...(rule.muteAll !== undefined ? {
      mute_all: rule.muteAll
    } : {}),
    ...(rule.notifyWhen !== undefined ? {
      notify_when: rule.notifyWhen
    } : {}),
    ...(rule.mutedInstanceIds ? {
      muted_alert_ids: rule.mutedInstanceIds
    } : {}),
    ...(rule.scheduledTaskId !== undefined ? {
      scheduled_task_id: rule.scheduledTaskId
    } : {}),
    ...(rule.executionStatus ? {
      execution_status: {
        status: rule.executionStatus.status,
        ...(rule.executionStatus.error ? {
          error: rule.executionStatus.error
        } : {}),
        ...(rule.executionStatus.warning ? {
          warning: rule.executionStatus.warning
        } : {}),
        last_execution_date: (_rule$executionStatus = rule.executionStatus.lastExecutionDate) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.toISOString(),
        ...(rule.executionStatus.lastDuration !== undefined ? {
          last_duration: rule.executionStatus.lastDuration
        } : {})
      }
    } : {}),
    ...(rule.monitoring ? {
      monitoring: (0, _transforms.transformMonitoringV1)(rule.monitoring)
    } : {}),
    ...(rule.snoozeSchedule ? {
      snooze_schedule: rule.snoozeSchedule
    } : {}),
    ...(rule.activeSnoozes ? {
      active_snoozes: rule.activeSnoozes
    } : {}),
    ...(rule.isSnoozedUntil !== undefined ? {
      is_snoozed_until: ((_rule$isSnoozedUntil = rule.isSnoozedUntil) === null || _rule$isSnoozedUntil === void 0 ? void 0 : _rule$isSnoozedUntil.toISOString()) || null
    } : {}),
    ...(rule.lastRun !== undefined ? {
      last_run: rule.lastRun ? (0, _transforms.transformRuleLastRunV1)(rule.lastRun) : null
    } : {}),
    ...(rule.nextRun !== undefined ? {
      next_run: ((_rule$nextRun = rule.nextRun) === null || _rule$nextRun === void 0 ? void 0 : _rule$nextRun.toISOString()) || null
    } : {}),
    ...(rule.revision !== undefined ? {
      revision: rule.revision
    } : {}),
    ...(rule.running !== undefined ? {
      running: rule.running
    } : {}),
    ...(rule.viewInAppRelativeUrl !== undefined ? {
      view_in_app_relative_url: rule.viewInAppRelativeUrl
    } : {}),
    ...(rule.alertDelay !== undefined ? {
      alert_delay: rule.alertDelay
    } : {})
  };
  for (const key in ruleResponse) {
    if (ruleResponse[key] !== undefined) {
      continue;
    }
    if (!fields) {
      continue;
    }
    if (fields.includes(key)) {
      continue;
    }
    delete ruleResponse[key];
  }
  return ruleResponse;
};
exports.transformPartialRule = transformPartialRule;
const transformFindRulesResponse = (result, fields) => {
  return {
    page: result.page,
    per_page: result.perPage,
    total: result.total,
    data: result.data.map(rule => transformPartialRule(rule, fields))
  };
};
exports.transformFindRulesResponse = transformFindRulesResponse;