"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkEnableRulesRoute = void 0;
var _lib = require("../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../types");
var _bulk_enable = require("../../../../../common/routes/rule/apis/bulk_enable");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkEnableRulesRoute = ({
  router,
  licenseState
}) => {
  router.patch({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_enable`,
    validate: {
      body: _bulk_enable.bulkEnableBodySchemaV1
    }
  }, (0, _lib.handleDisabledApiKeysError)(router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async (context, req, res) => {
    const rulesClient = (await context.alerting).getRulesClient();
    const body = req.body;
    try {
      const result = await rulesClient.bulkEnableRules({
        filter: body.filter,
        ids: body.ids
      });
      const response = (0, _transforms.transformBulkEnableResponseV1)(result);
      return res.ok({
        body: response
      });
    } catch (e) {
      if (e instanceof _lib2.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  }))));
};
exports.bulkEnableRulesRoute = bulkEnableRulesRoute;