"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBackfillRoute = void 0;
var _get = require("../../../../../common/routes/backfill/apis/get");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBackfillRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/backfill/{id}`,
    validate: {
      params: _get.getParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;
    const result = await rulesClient.getBackfill(params.id);
    const response = {
      body: (0, _transforms.transformBackfillToBackfillResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.getBackfillRoute = getBackfillRoute;