"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findBackfillRoute = void 0;
var _find = require("../../../../../common/routes/backfill/apis/find");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findBackfillRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_ALERTING_BACKFILL_FIND_API_PATH}`,
    validate: {
      query: _find.findQuerySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const query = req.query;
    const result = await rulesClient.findBackfill((0, _transforms.transformRequestV1)(query));
    const response = {
      body: (0, _transforms.transformResponseV1)(result)
    };
    return res.ok(response);
  })));
};
exports.findBackfillRoute = findBackfillRoute;