"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LEGACY_EVENT_LOG_ACTIONS = exports.EVENT_LOG_PROVIDER = exports.EVENT_LOG_ACTIONS = exports.AlertingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _common = require("@kbn/spaces-plugin/common");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/licensing-plugin/server");
var _rule_type_registry = require("./rule_type_registry");
var _task_runner = require("./task_runner");
var _rules_client_factory = require("./rules_client_factory");
var _rules_settings_client_factory = require("./rules_settings_client_factory");
var _maintenance_window_client_factory = require("./maintenance_window_client_factory");
var _license_state = require("./lib/license_state");
var _types = require("./types");
var _routes = require("./routes");
var _usage = require("./usage");
var _task = require("./usage/task");
var _saved_objects = require("./saved_objects");
var _task2 = require("./invalidate_pending_api_keys/task");
var _health = require("./health");
var _get_health = require("./health/get_health");
var _alerting_authorization_client_factory = require("./alerting_authorization_client_factory");
var _get_security_health = require("./lib/get_security_health");
var _monitoring = require("./monitoring");
var _get_rule_task_timeout = require("./lib/get_rule_task_timeout");
var _get_actions_config_map = require("./lib/get_actions_config_map");
var _alerts_service = require("./alerts_service");
var _rules_settings_feature = require("./rules_settings_feature");
var _maintenance_window_feature = require("./maintenance_window_feature");
var _connector_adapter_registry = require("./connector_adapters/connector_adapter_registry");
var _data_stream_adapter = require("./alerts_service/lib/data_stream_adapter");
var _lib = require("./lib");
var _backfill_client = require("./backfill_client/backfill_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EVENT_LOG_PROVIDER = exports.EVENT_LOG_PROVIDER = 'alerting';
const EVENT_LOG_ACTIONS = exports.EVENT_LOG_ACTIONS = {
  execute: 'execute',
  executeStart: 'execute-start',
  executeAction: 'execute-action',
  executeBackfill: 'execute-backfill',
  newInstance: 'new-instance',
  recoveredInstance: 'recovered-instance',
  activeInstance: 'active-instance',
  executeTimeout: 'execute-timeout',
  untrackedInstance: 'untracked-instance'
};
const LEGACY_EVENT_LOG_ACTIONS = exports.LEGACY_EVENT_LOG_ACTIONS = {
  resolvedInstance: 'resolved-instance'
};
class AlertingPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "ruleTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "taskRunnerFactory", void 0);
    (0, _defineProperty2.default)(this, "licenseState", null);
    (0, _defineProperty2.default)(this, "isESOCanEncrypt", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    (0, _defineProperty2.default)(this, "rulesClientFactory", void 0);
    (0, _defineProperty2.default)(this, "alertingAuthorizationClientFactory", void 0);
    (0, _defineProperty2.default)(this, "rulesSettingsClientFactory", void 0);
    (0, _defineProperty2.default)(this, "maintenanceWindowClientFactory", void 0);
    (0, _defineProperty2.default)(this, "telemetryLogger", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "eventLogService", void 0);
    (0, _defineProperty2.default)(this, "eventLogger", void 0);
    (0, _defineProperty2.default)(this, "kibanaBaseUrl", void 0);
    (0, _defineProperty2.default)(this, "usageCounter", void 0);
    (0, _defineProperty2.default)(this, "inMemoryMetrics", void 0);
    (0, _defineProperty2.default)(this, "alertsService", void 0);
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    (0, _defineProperty2.default)(this, "dataStreamAdapter", void 0);
    (0, _defineProperty2.default)(this, "backfillClient", void 0);
    (0, _defineProperty2.default)(this, "nodeRoles", void 0);
    (0, _defineProperty2.default)(this, "connectorAdapterRegistry", new _connector_adapter_registry.ConnectorAdapterRegistry());
    (0, _defineProperty2.default)(this, "createRouteHandlerContext", core => {
      const {
        ruleTypeRegistry,
        rulesClientFactory,
        rulesSettingsClientFactory,
        maintenanceWindowClientFactory
      } = this;
      return async function alertsRouteHandlerContext(context, request) {
        const [{
          savedObjects
        }] = await core.getStartServices();
        return {
          getRulesClient: () => {
            return rulesClientFactory.create(request, savedObjects);
          },
          getRulesSettingsClient: () => {
            return rulesSettingsClientFactory.createWithAuthorization(request);
          },
          getMaintenanceWindowClient: () => {
            return maintenanceWindowClientFactory.createWithAuthorization(request);
          },
          listTypes: ruleTypeRegistry.list.bind(ruleTypeRegistry),
          getFrameworkHealth: async () => await (0, _get_health.getHealth)(savedObjects.createInternalRepository([_saved_objects.RULE_SAVED_OBJECT_TYPE])),
          areApiKeysEnabled: async () => {
            var _security$authc$apiKe;
            const [, {
              security
            }] = await core.getStartServices();
            return (_security$authc$apiKe = security === null || security === void 0 ? void 0 : security.authc.apiKeys.areAPIKeysEnabled()) !== null && _security$authc$apiKe !== void 0 ? _security$authc$apiKe : false;
          }
        };
      };
    });
    this.config = initializerContext.config.get();
    this.logger = initializerContext.logger.get();
    this.taskRunnerFactory = new _task_runner.TaskRunnerFactory();
    this.rulesClientFactory = new _rules_client_factory.RulesClientFactory();
    this.alertsService = null;
    this.nodeRoles = initializerContext.node.roles;
    this.alertingAuthorizationClientFactory = new _alerting_authorization_client_factory.AlertingAuthorizationClientFactory();
    this.rulesSettingsClientFactory = new _rules_settings_client_factory.RulesSettingsClientFactory();
    this.maintenanceWindowClientFactory = new _maintenance_window_client_factory.MaintenanceWindowClientFactory();
    this.telemetryLogger = initializerContext.logger.get('usage');
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.inMemoryMetrics = new _monitoring.InMemoryMetrics(initializerContext.logger.get('in_memory_metrics'));
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
  }
  setup(core, plugins) {
    var _plugins$usageCollect;
    this.kibanaBaseUrl = core.http.basePath.publicBaseUrl;
    this.licenseState = new _license_state.LicenseState(plugins.licensing.license$);
    this.security = plugins.security;
    const useDataStreamForAlerts = !!plugins.serverless;
    this.dataStreamAdapter = (0, _data_stream_adapter.getDataStreamAdapter)({
      useDataStreamForAlerts
    });
    core.capabilities.registerProvider(() => {
      return {
        management: {
          insightsAndAlerting: {
            triggersActions: true,
            maintenanceWindows: true
          }
        }
      };
    });
    plugins.features.registerKibanaFeature((0, _rules_settings_feature.getRulesSettingsFeature)(!!plugins.serverless));
    plugins.features.registerKibanaFeature(_maintenance_window_feature.maintenanceWindowFeature);
    this.isESOCanEncrypt = plugins.encryptedSavedObjects.canEncrypt;
    if (!this.isESOCanEncrypt) {
      this.logger.warn('APIs are disabled because the Encrypted Saved Objects plugin is missing encryption key. Please set xpack.encryptedSavedObjects.encryptionKey in the kibana.yml or use the bin/kibana-encryption-keys command.');
    }
    const taskManagerStartPromise = core.getStartServices().then(([_, alertingStart]) => alertingStart.taskManager);
    this.backfillClient = new _backfill_client.BackfillClient({
      logger: this.logger,
      taskManagerSetup: plugins.taskManager,
      taskManagerStartPromise,
      taskRunnerFactory: this.taskRunnerFactory
    });
    this.eventLogger = plugins.eventLog.getLogger({
      event: {
        provider: EVENT_LOG_PROVIDER
      }
    });
    this.eventLogService = plugins.eventLog;
    plugins.eventLog.registerProviderActions(EVENT_LOG_PROVIDER, Object.values(EVENT_LOG_ACTIONS));
    if (this.config.enableFrameworkAlerts) {
      if (this.nodeRoles.migrator) {
        this.logger.info(`Skipping initialization of AlertsService on migrator node`);
      } else {
        this.logger.info(`using ${this.dataStreamAdapter.isUsingDataStreams() ? 'datastreams' : 'indexes and aliases'} for persisting alerts`);
        this.alertsService = new _alerts_service.AlertsService({
          logger: this.logger,
          pluginStop$: this.pluginStop$,
          kibanaVersion: this.kibanaVersion,
          dataStreamAdapter: this.dataStreamAdapter,
          elasticsearchClientPromise: core.getStartServices().then(([{
            elasticsearch
          }]) => elasticsearch.client.asInternalUser)
        });
      }
    }
    const ruleTypeRegistry = new _rule_type_registry.RuleTypeRegistry({
      config: this.config,
      logger: this.logger,
      taskManager: plugins.taskManager,
      taskRunnerFactory: this.taskRunnerFactory,
      licenseState: this.licenseState,
      licensing: plugins.licensing,
      alertsService: this.alertsService,
      minimumScheduleInterval: this.config.rules.minimumScheduleInterval,
      inMemoryMetrics: this.inMemoryMetrics
    });
    this.ruleTypeRegistry = ruleTypeRegistry;
    const usageCollection = plugins.usageCollection;
    if (usageCollection) {
      (0, _usage.registerAlertingUsageCollector)(usageCollection, taskManagerStartPromise);
      const eventLogIndex = this.eventLogService.getIndexPattern();
      (0, _task.initializeAlertingTelemetry)(this.telemetryLogger, core, plugins.taskManager, eventLogIndex);
    }

    // Usage counter for telemetry
    this.usageCounter = (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.createUsageCounter(_types.ALERTING_FEATURE_ID);
    const getSearchSourceMigrations = plugins.data.search.searchSource.getAllMigrations.bind(plugins.data.search.searchSource);
    (0, _saved_objects.setupSavedObjects)(core.savedObjects, plugins.encryptedSavedObjects, this.ruleTypeRegistry, this.logger, plugins.actions.isPreconfiguredConnector, getSearchSourceMigrations);
    (0, _task2.initializeApiKeyInvalidator)(this.logger, core.getStartServices(), plugins.taskManager, this.config);
    const serviceStatus$ = new _rxjs.BehaviorSubject({
      level: _server.ServiceStatusLevels.available,
      summary: 'Alerting is (probably) ready'
    });
    core.status.set(serviceStatus$);
    (0, _health.initializeAlertingHealth)(this.logger, plugins.taskManager, core.getStartServices());
    core.http.registerRouteHandlerContext('alerting', this.createRouteHandlerContext(core));
    if (plugins.monitoringCollection) {
      (0, _monitoring.registerNodeCollector)({
        monitoringCollection: plugins.monitoringCollection,
        inMemoryMetrics: this.inMemoryMetrics
      });
      (0, _monitoring.registerClusterCollector)({
        monitoringCollection: plugins.monitoringCollection,
        core
      });
    }

    // Routes
    const router = core.http.createRouter();
    // Register routes
    (0, _routes.defineRoutes)({
      router,
      licenseState: this.licenseState,
      usageCounter: this.usageCounter,
      getAlertIndicesAlias: (0, _lib.createGetAlertIndicesAliasFn)(this.ruleTypeRegistry),
      encryptedSavedObjects: plugins.encryptedSavedObjects,
      config$: plugins.unifiedSearch.autocomplete.getInitializerContextConfig().create()
    });
    return {
      registerConnectorAdapter: adapter => {
        this.connectorAdapterRegistry.register(adapter);
      },
      registerType: ruleType => {
        var _ruleType$cancelAlert, _ruleType$doesSetReco, _ruleType$autoRecover;
        if (!(ruleType.minimumLicenseRequired in _server2.LICENSE_TYPE)) {
          throw new Error(`"${ruleType.minimumLicenseRequired}" is not a valid license type`);
        }
        ruleType.ruleTaskTimeout = (0, _get_rule_task_timeout.getRuleTaskTimeout)({
          config: this.config.rules,
          ruleTaskTimeout: ruleType.ruleTaskTimeout,
          ruleTypeId: ruleType.id
        });
        ruleType.cancelAlertsOnRuleTimeout = (_ruleType$cancelAlert = ruleType.cancelAlertsOnRuleTimeout) !== null && _ruleType$cancelAlert !== void 0 ? _ruleType$cancelAlert : this.config.cancelAlertsOnRuleTimeout;
        ruleType.doesSetRecoveryContext = (_ruleType$doesSetReco = ruleType.doesSetRecoveryContext) !== null && _ruleType$doesSetReco !== void 0 ? _ruleType$doesSetReco : false;
        ruleType.autoRecoverAlerts = (_ruleType$autoRecover = ruleType.autoRecoverAlerts) !== null && _ruleType$autoRecover !== void 0 ? _ruleType$autoRecover : true;
        ruleTypeRegistry.register(ruleType);
      },
      getSecurityHealth: async () => {
        return await (0, _get_security_health.getSecurityHealth)(async () => this.licenseState ? this.licenseState.getIsSecurityEnabled() : null, async () => plugins.encryptedSavedObjects.canEncrypt, async () => {
          var _security$authc$apiKe2;
          const [, {
            security
          }] = await core.getStartServices();
          return (_security$authc$apiKe2 = security === null || security === void 0 ? void 0 : security.authc.apiKeys.areAPIKeysEnabled()) !== null && _security$authc$apiKe2 !== void 0 ? _security$authc$apiKe2 : false;
        });
      },
      getConfig: () => {
        return {
          ...(0, _lodash.pick)(this.config.rules, ['minimumScheduleInterval', 'maxScheduledPerMinute', 'run']),
          isUsingSecurity: this.licenseState ? !!this.licenseState.getIsSecurityEnabled() : false
        };
      },
      frameworkAlerts: {
        enabled: () => this.config.enableFrameworkAlerts,
        getContextInitializationPromise: (context, namespace) => {
          if (this.alertsService) {
            return this.alertsService.getContextInitializationPromise(context, namespace);
          }
          return Promise.resolve((0, _alerts_service.errorResult)(`Framework alerts service not available`));
        }
      },
      getDataStreamAdapter: () => this.dataStreamAdapter
    };
  }
  start(core, plugins) {
    const {
      isESOCanEncrypt,
      logger,
      taskRunnerFactory,
      ruleTypeRegistry,
      rulesClientFactory,
      alertingAuthorizationClientFactory,
      rulesSettingsClientFactory,
      maintenanceWindowClientFactory,
      security,
      licenseState
    } = this;
    licenseState === null || licenseState === void 0 ? void 0 : licenseState.setNotifyUsage(plugins.licensing.featureUsage.notifyUsage);
    const encryptedSavedObjectsClient = plugins.encryptedSavedObjects.getClient({
      includedHiddenTypes: [_saved_objects.RULE_SAVED_OBJECT_TYPE, _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE]
    });
    const spaceIdToNamespace = spaceId => {
      return plugins.spaces && spaceId ? plugins.spaces.spacesService.spaceIdToNamespace(spaceId) : undefined;
    };
    alertingAuthorizationClientFactory.initialize({
      ruleTypeRegistry: ruleTypeRegistry,
      securityPluginSetup: security,
      securityPluginStart: plugins.security,
      async getSpace(request) {
        var _plugins$spaces;
        return (_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.spacesService.getActiveSpace(request);
      },
      getSpaceId(request) {
        var _plugins$spaces$space, _plugins$spaces2;
        return (_plugins$spaces$space = (_plugins$spaces2 = plugins.spaces) === null || _plugins$spaces2 === void 0 ? void 0 : _plugins$spaces2.spacesService.getSpaceId(request)) !== null && _plugins$spaces$space !== void 0 ? _plugins$spaces$space : _common.DEFAULT_SPACE_ID;
      },
      features: plugins.features
    });
    rulesClientFactory.initialize({
      ruleTypeRegistry: ruleTypeRegistry,
      logger,
      taskManager: plugins.taskManager,
      securityPluginSetup: security,
      securityPluginStart: plugins.security,
      internalSavedObjectsRepository: core.savedObjects.createInternalRepository([_saved_objects.RULE_SAVED_OBJECT_TYPE]),
      encryptedSavedObjectsClient,
      spaceIdToNamespace,
      getSpaceId(request) {
        var _plugins$spaces$space2, _plugins$spaces3;
        return (_plugins$spaces$space2 = (_plugins$spaces3 = plugins.spaces) === null || _plugins$spaces3 === void 0 ? void 0 : _plugins$spaces3.spacesService.getSpaceId(request)) !== null && _plugins$spaces$space2 !== void 0 ? _plugins$spaces$space2 : _common.DEFAULT_SPACE_ID;
      },
      actions: plugins.actions,
      eventLog: plugins.eventLog,
      kibanaVersion: this.kibanaVersion,
      authorization: alertingAuthorizationClientFactory,
      eventLogger: this.eventLogger,
      minimumScheduleInterval: this.config.rules.minimumScheduleInterval,
      maxScheduledPerMinute: this.config.rules.maxScheduledPerMinute,
      getAlertIndicesAlias: (0, _lib.createGetAlertIndicesAliasFn)(this.ruleTypeRegistry),
      alertsService: this.alertsService,
      backfillClient: this.backfillClient,
      connectorAdapterRegistry: this.connectorAdapterRegistry,
      uiSettings: core.uiSettings,
      securityService: core.security
    });
    rulesSettingsClientFactory.initialize({
      logger: this.logger,
      savedObjectsService: core.savedObjects,
      securityService: core.security,
      isServerless: !!plugins.serverless
    });
    maintenanceWindowClientFactory.initialize({
      logger: this.logger,
      savedObjectsService: core.savedObjects,
      securityService: core.security,
      uiSettings: core.uiSettings
    });
    const getRulesClientWithRequest = request => {
      if (isESOCanEncrypt !== true) {
        throw new Error(`Unable to create alerts client because the Encrypted Saved Objects plugin is missing encryption key. Please set xpack.encryptedSavedObjects.encryptionKey in the kibana.yml or use the bin/kibana-encryption-keys command.`);
      }
      return rulesClientFactory.create(request, core.savedObjects);
    };
    const getAlertingAuthorizationWithRequest = request => {
      return alertingAuthorizationClientFactory.create(request);
    };
    const getRulesSettingsClientWithRequest = request => {
      return rulesSettingsClientFactory.create(request);
    };
    const getMaintenanceWindowClientWithRequest = request => {
      return maintenanceWindowClientFactory.create(request);
    };
    taskRunnerFactory.initialize({
      logger,
      data: plugins.data,
      share: plugins.share,
      dataViews: plugins.dataViews,
      savedObjects: core.savedObjects,
      uiSettings: core.uiSettings,
      elasticsearch: core.elasticsearch,
      getRulesClientWithRequest,
      spaceIdToNamespace,
      actionsPlugin: plugins.actions,
      encryptedSavedObjectsClient,
      basePathService: core.http.basePath,
      eventLogger: this.eventLogger,
      executionContext: core.executionContext,
      ruleTypeRegistry: this.ruleTypeRegistry,
      alertsService: this.alertsService,
      kibanaBaseUrl: this.kibanaBaseUrl,
      supportsEphemeralTasks: plugins.taskManager.supportsEphemeralTasks(),
      maxEphemeralActionsPerRule: this.config.maxEphemeralActionsPerAlert,
      cancelAlertsOnRuleTimeout: this.config.cancelAlertsOnRuleTimeout,
      maxAlerts: this.config.rules.run.alerts.max,
      actionsConfigMap: (0, _get_actions_config_map.getActionsConfigMap)(this.config.rules.run.actions),
      usageCounter: this.usageCounter,
      getRulesSettingsClientWithRequest,
      getMaintenanceWindowClientWithRequest,
      backfillClient: this.backfillClient,
      connectorAdapterRegistry: this.connectorAdapterRegistry
    });
    this.eventLogService.registerSavedObjectProvider(_saved_objects.RULE_SAVED_OBJECT_TYPE, request => {
      const client = getRulesClientWithRequest(request);
      return objects => objects ? Promise.all(objects.map(async objectItem => await client.get({
        id: objectItem.id
      }))) : Promise.resolve([]);
    });
    this.eventLogService.isEsContextReady().then(() => {
      (0, _task.scheduleAlertingTelemetry)(this.telemetryLogger, plugins.taskManager);
    }).catch(() => {}); // it shouldn't reject, but just in case

    (0, _health.scheduleAlertingHealthCheck)(this.logger, this.config, plugins.taskManager).catch(() => {}); // it shouldn't reject, but just in case
    (0, _task2.scheduleApiKeyInvalidatorTask)(this.telemetryLogger, this.config, plugins.taskManager).catch(() => {}); // it shouldn't reject, but just in case

    return {
      listTypes: ruleTypeRegistry.list.bind(this.ruleTypeRegistry),
      getType: ruleTypeRegistry.get.bind(this.ruleTypeRegistry),
      getAllTypes: ruleTypeRegistry.getAllTypes.bind(this.ruleTypeRegistry),
      getAlertIndicesAlias: (0, _lib.createGetAlertIndicesAliasFn)(this.ruleTypeRegistry),
      getAlertingAuthorizationWithRequest,
      getRulesClientWithRequest,
      getFrameworkHealth: async () => await (0, _get_health.getHealth)(core.savedObjects.createInternalRepository([_saved_objects.RULE_SAVED_OBJECT_TYPE]))
    };
  }
  stop() {
    if (this.licenseState) {
      this.licenseState.clean();
    }
    this.pluginStop$.next();
    this.pluginStop$.complete();
  }
}
exports.AlertingPlugin = AlertingPlugin;