"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleDataSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validation = require("../../../validation");
var _schemas = require("../../../schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleDataSchema = exports.createRuleDataSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  alertTypeId: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  consumer: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    validate: _validation.validateDuration
  }))),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()), {
    defaultValue: {}
  }),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: _validation.validateDuration
    })
  }),
  actions: _configSchema.schema.arrayOf(_schemas.actionRequestSchema, {
    defaultValue: []
  }),
  systemActions: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_schemas.systemActionRequestSchema, {
    defaultValue: []
  })),
  notifyWhen: _configSchema.schema.maybe(_configSchema.schema.nullable(_schemas.notifyWhenSchema)),
  alertDelay: _configSchema.schema.maybe(_schemas.alertDelaySchema)
}, {
  unknowns: 'allow'
});