"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rRuleRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validation = require("../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rRuleRequestSchema = exports.rRuleRequestSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string({
    validate: _validation.validateStartDate
  }),
  tzid: _configSchema.schema.string(),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3)])),
  interval: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: interval => {
      if (interval < 1) return 'rRule interval must be > 0';
    }
  })),
  until: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: _validation.validateEndDate
  })),
  count: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: count => {
      if (count < 1) return 'rRule count must be > 0';
    }
  })),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: (0, _validation.createValidateRecurrenceBy)('byweekday')
  })),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
    validate: (0, _validation.createValidateRecurrenceBy)('bymonthday')
  })),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number(), {
    validate: (0, _validation.createValidateRecurrenceBy)('bymonth')
  }))
});