"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAdHocRunToBackfillResult = void 0;
var _lib = require("../../../backfill_client/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAdHocRunToBackfillResult = ({
  id,
  attributes,
  references,
  error
}, originalSO) => {
  var _ref, _references$0$id, _references$, _originalSO$reference, _originalSO$reference2, _attributes$rule$name, _attributes$rule, _originalSO$attribute;
  const ruleId = (_ref = (_references$0$id = references === null || references === void 0 ? void 0 : (_references$ = references[0]) === null || _references$ === void 0 ? void 0 : _references$.id) !== null && _references$0$id !== void 0 ? _references$0$id : originalSO === null || originalSO === void 0 ? void 0 : (_originalSO$reference = originalSO.references) === null || _originalSO$reference === void 0 ? void 0 : (_originalSO$reference2 = _originalSO$reference[0]) === null || _originalSO$reference2 === void 0 ? void 0 : _originalSO$reference2.id) !== null && _ref !== void 0 ? _ref : 'unknown';
  const ruleName = (_attributes$rule$name = attributes === null || attributes === void 0 ? void 0 : (_attributes$rule = attributes.rule) === null || _attributes$rule === void 0 ? void 0 : _attributes$rule.name) !== null && _attributes$rule$name !== void 0 ? _attributes$rule$name : originalSO === null || originalSO === void 0 ? void 0 : (_originalSO$attribute = originalSO.attributes) === null || _originalSO$attribute === void 0 ? void 0 : _originalSO$attribute.rule.name;
  if (error) {
    // get rule info from original SO if available since SO create errors don't return this
    return (0, _lib.createBackfillError)(error.message, ruleId, ruleName);
  }
  if (!id) {
    return (0, _lib.createBackfillError)('Malformed saved object in bulkCreate response - Missing "id".', ruleId, ruleName);
  }
  if (!attributes) {
    return (0, _lib.createBackfillError)('Malformed saved object in bulkCreate response - Missing "attributes".', ruleId, ruleName);
  }
  if (!references || !references.length) {
    return (0, _lib.createBackfillError)('Malformed saved object in bulkCreate response - Missing "references".', ruleId, ruleName);
  }
  return {
    id,
    // exclude API key information
    createdAt: attributes.createdAt,
    duration: attributes.duration,
    enabled: attributes.enabled,
    ...(attributes.end ? {
      end: attributes.end
    } : {}),
    rule: {
      ...attributes.rule,
      id: references[0].id
    },
    spaceId: attributes.spaceId,
    start: attributes.start,
    status: attributes.status,
    schedule: attributes.schedule
  };
};
exports.transformAdHocRunToBackfillResult = transformAdHocRunToBackfillResult;