"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleBackfillParamsSchema = exports.scheduleBackfillParamSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../../common");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleBackfillParamSchema = exports.scheduleBackfillParamSchema = _configSchema.schema.object({
  ruleId: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  end: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  validate({
    start,
    end
  }) {
    return (0, _common.validateBackfillSchedule)(start, end);
  }
});
const scheduleBackfillParamsSchema = exports.scheduleBackfillParamsSchema = _configSchema.schema.arrayOf(scheduleBackfillParamSchema, {
  minSize: 1,
  maxSize: _constants.MAX_SCHEDULE_BACKFILL_BULK_SIZE
});