"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteBackfill = deleteBackfill;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _saved_objects = require("../../../../saved_objects");
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteBackfill(context, id) {
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.deleteBackfill('${id}')`, async () => await deleteWithOCC(context, {
    id
  }));
}
async function deleteWithOCC(context, {
  id
}) {
  try {
    var _context$auditLogger3;
    const result = await context.unsecuredSavedObjectsClient.get(_saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE, id);

    // Check for errors in the savedObjectClient result
    if (result.error) {
      var _context$auditLogger;
      const err = new Error(result.error.message);
      (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.adHocRunAuditEvent)({
        action: _audit_events.AdHocRunAuditAction.DELETE,
        savedObject: {
          type: _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE,
          id
        },
        error: new Error(result.error.message)
      }));
      throw err;
    }
    try {
      await context.authorization.ensureAuthorized({
        ruleTypeId: result.attributes.rule.alertTypeId,
        consumer: result.attributes.rule.consumer,
        operation: _authorization.WriteOperations.DeleteBackfill,
        entity: _authorization.AlertingAuthorizationEntity.Rule
      });
    } catch (error) {
      var _context$auditLogger2;
      (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.adHocRunAuditEvent)({
        action: _audit_events.AdHocRunAuditAction.DELETE,
        savedObject: {
          type: _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE,
          id,
          name: `backfill for rule "${result.attributes.rule.name}"`
        },
        error
      }));
      throw error;
    }
    (_context$auditLogger3 = context.auditLogger) === null || _context$auditLogger3 === void 0 ? void 0 : _context$auditLogger3.log((0, _audit_events.adHocRunAuditEvent)({
      action: _audit_events.AdHocRunAuditAction.DELETE,
      outcome: 'unknown',
      savedObject: {
        type: _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE,
        id,
        name: `backfill for rule "${result.attributes.rule.name}"`
      }
    }));

    // delete the saved object
    const removeResult = await context.unsecuredSavedObjectsClient.delete(_saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE, id);

    // remove the associated task
    await context.taskManager.removeIfExists(id);
    return removeResult;
  } catch (err) {
    const errorMessage = `Failed to delete backfill by id: ${id}`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}