"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeAlertsClient = void 0;
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _ = require("..");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeAlertsClient = async ({
  alertsService,
  context,
  executionId,
  logger,
  maxAlerts,
  rule,
  ruleType,
  runTimestamp,
  startedAt,
  taskInstance
}) => {
  var _context$flappingSett;
  const {
    state: {
      alertInstances: alertRawInstances = {},
      alertRecoveredInstances: alertRecoveredRawInstances = {}
    }
  } = taskInstance;
  const alertsClientParams = {
    logger,
    ruleType
  };

  // Create AlertsClient if rule type has registered an alerts context
  // with the framework. The AlertsClient will handle reading and
  // writing from alerts-as-data indices and eventually
  // we will want to migrate all the processing of alerts out
  // of the LegacyAlertsClient and into the AlertsClient.
  let alertsClient;
  try {
    var _await$alertsService$, _context$namespace, _rule$alertDelay$acti, _rule$alertDelay;
    const client = (_await$alertsService$ = await (alertsService === null || alertsService === void 0 ? void 0 : alertsService.createAlertsClient({
      ...alertsClientParams,
      namespace: (_context$namespace = context.namespace) !== null && _context$namespace !== void 0 ? _context$namespace : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING,
      rule: {
        consumer: rule.consumer,
        executionId,
        id: rule.id,
        name: rule.name,
        parameters: rule.params,
        revision: rule.revision,
        spaceId: context.spaceId,
        tags: rule.tags,
        alertDelay: (_rule$alertDelay$acti = (_rule$alertDelay = rule.alertDelay) === null || _rule$alertDelay === void 0 ? void 0 : _rule$alertDelay.active) !== null && _rule$alertDelay$acti !== void 0 ? _rule$alertDelay$acti : 0
      }
    }))) !== null && _await$alertsService$ !== void 0 ? _await$alertsService$ : null;
    alertsClient = client ? client : new _.LegacyAlertsClient(alertsClientParams);
  } catch (err) {
    var _ruleType$alerts;
    logger.error(`Error initializing AlertsClient for context ${(_ruleType$alerts = ruleType.alerts) === null || _ruleType$alerts === void 0 ? void 0 : _ruleType$alerts.context}. Using legacy alerts client instead. - ${err.message}`);
    alertsClient = new _.LegacyAlertsClient(alertsClientParams);
  }
  await alertsClient.initializeExecution({
    maxAlerts,
    ruleLabel: context.ruleLogPrefix,
    flappingSettings: (_context$flappingSett = context.flappingSettings) !== null && _context$flappingSett !== void 0 ? _context$flappingSett : _types.DEFAULT_FLAPPING_SETTINGS,
    startedAt,
    runTimestamp,
    activeAlertsFromState: alertRawInstances,
    recoveredAlertsFromState: alertRecoveredRawInstances
  });
  return alertsClient;
};
exports.initializeAlertsClient = initializeAlertsClient;