"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWeekdayInfo = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWeekdayInfo = (date, dayOfWeekFmt = 'dddd') => {
  const dayOfWeek = date.format(dayOfWeekFmt);
  const nthWeekdayOfMonth = Math.ceil(date.date() / 7);
  const isLastOfMonth = nthWeekdayOfMonth > 4 || !date.isSame((0, _moment.default)(date).add(7, 'd'), 'month');
  return {
    dayOfWeek,
    nthWeekdayOfMonth,
    isLastOfMonth
  };
};
exports.getWeekdayInfo = getWeekdayInfo;