"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateParamsSchema = exports.updateBodySchema = exports.actionSchema = exports.actionFrequencySchema = exports.actionAlertsFilterSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validation = require("../../../validation");
var _response = require("../../../response");
var _alerts_filter_query = require("../../../../alerts_filter_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionFrequencySchema = exports.actionFrequencySchema = _configSchema.schema.object({
  summary: _configSchema.schema.boolean(),
  notify_when: _response.notifyWhenSchemaV1,
  throttle: _configSchema.schema.nullable(_configSchema.schema.string({
    validate: _validation.validateDurationV1
  }))
});
const actionAlertsFilterSchema = exports.actionAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_alerts_filter_query.alertsFilterQuerySchemaV1),
  timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
    days: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)])),
    hours: _configSchema.schema.object({
      start: _configSchema.schema.string({
        validate: _validation.validateHoursV1
      }),
      end: _configSchema.schema.string({
        validate: _validation.validateHoursV1
      })
    }),
    timezone: _configSchema.schema.string({
      validate: _validation.validateTimezoneV1
    })
  }))
});
const actionSchema = exports.actionSchema = _configSchema.schema.object({
  group: _configSchema.schema.maybe(_configSchema.schema.string()),
  id: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {}
  }),
  frequency: _configSchema.schema.maybe(actionFrequencySchema),
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  alerts_filter: _configSchema.schema.maybe(actionAlertsFilterSchema),
  use_alert_data_for_template: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const updateBodySchema = exports.updateBodySchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  schedule: _configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: _validation.validateDurationV1
    })
  }),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string({
    validate: _validation.validateDurationV1
  }))),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {}
  }),
  actions: _configSchema.schema.arrayOf(actionSchema, {
    defaultValue: []
  }),
  notify_when: _configSchema.schema.maybe(_configSchema.schema.nullable(_response.notifyWhenSchemaV1)),
  alert_delay: _configSchema.schema.maybe(_response.alertDelaySchemaV1)
});
const updateParamsSchema = exports.updateParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});