"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComponentTemplateFromFieldMap = void 0;
var _mapping_from_field_map = require("./mapping_from_field_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getComponentTemplateFromFieldMap = ({
  name,
  fieldMap,
  dynamic,
  includeSettings
}) => {
  return {
    name,
    _meta: {
      managed: true
    },
    template: {
      settings: {
        ...(includeSettings ? {
          number_of_shards: 1,
          'index.mapping.total_fields.limit': Math.ceil(Object.keys(fieldMap).length / 1000) * 1000 + 500
        } : {})
      },
      mappings: (0, _mapping_from_field_map.mappingFromFieldMap)(fieldMap, dynamic !== null && dynamic !== void 0 ? dynamic : 'strict')
    }
  };
};
exports.getComponentTemplateFromFieldMap = getComponentTemplateFromFieldMap;