"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.topItemsHandlerFactory = void 0;
var _async = require("async");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _i18n = require("@kbn/i18n");
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
var _is_request_aborted_error = require("@kbn/aiops-common/is_request_aborted_error");
var _fetch_top_categories = require("@kbn/aiops-log-rate-analysis/queries/fetch_top_categories");
var _fetch_top_terms = require("@kbn/aiops-log-rate-analysis/queries/fetch_top_terms");
var _constants = require("../response_stream_utils/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const topItemsHandlerFactory = ({
  abortSignal,
  client,
  logDebugMessage,
  logger,
  requestBody,
  responseStream,
  stateHandler
}) => async ({
  fieldCandidates,
  textFieldCandidates
}) => {
  var _overrides$significan, _overrides, _overrides$significan2, _overrides$significan3, _overrides2, _overrides2$significa, _requestBody$override;
  let fieldCandidatesCount = fieldCandidates.length;

  // This will store the combined count of detected log patterns and keywords
  let fieldValuePairsCount = 0;
  const topCategories = [];
  topCategories.push(...((_overrides$significan = (_overrides = requestBody.overrides) === null || _overrides === void 0 ? void 0 : (_overrides$significan2 = _overrides.significantItems) === null || _overrides$significan2 === void 0 ? void 0 : _overrides$significan2.filter(d => d.type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.LOG_PATTERN)) !== null && _overrides$significan !== void 0 ? _overrides$significan : []));

  // Get categories of text fields
  if (textFieldCandidates.length > 0) {
    topCategories.push(...(await (0, _fetch_top_categories.fetchTopCategories)(client, requestBody, textFieldCandidates, logger, stateHandler.sampleProbability(), responseStream.pushError, abortSignal)));
    if (topCategories.length > 0) {
      responseStream.push((0, _stream_reducer.addSignificantItems)(topCategories));
    }
  }
  const topTerms = [];
  topTerms.push(...((_overrides$significan3 = (_overrides2 = requestBody.overrides) === null || _overrides2 === void 0 ? void 0 : (_overrides2$significa = _overrides2.significantItems) === null || _overrides2$significa === void 0 ? void 0 : _overrides2$significa.filter(d => d.type === _mlAggUtils.SIGNIFICANT_ITEM_TYPE.KEYWORD)) !== null && _overrides$significan3 !== void 0 ? _overrides$significan3 : []));
  const fieldsToSample = new Set();
  let remainingFieldCandidates;
  let loadingStepSizeTopTerms = _constants.PROGRESS_STEP_P_VALUES;
  if ((_requestBody$override = requestBody.overrides) !== null && _requestBody$override !== void 0 && _requestBody$override.remainingFieldCandidates) {
    var _requestBody$override2, _requestBody$override3, _requestBody$override4, _requestBody$override5;
    fieldCandidates.push(...((_requestBody$override2 = requestBody.overrides) === null || _requestBody$override2 === void 0 ? void 0 : _requestBody$override2.remainingFieldCandidates));
    remainingFieldCandidates = (_requestBody$override3 = requestBody.overrides) === null || _requestBody$override3 === void 0 ? void 0 : _requestBody$override3.remainingFieldCandidates;
    fieldCandidatesCount = fieldCandidates.length;
    loadingStepSizeTopTerms = _constants.LOADED_FIELD_CANDIDATES + _constants.PROGRESS_STEP_P_VALUES - ((_requestBody$override4 = (_requestBody$override5 = requestBody.overrides) === null || _requestBody$override5 === void 0 ? void 0 : _requestBody$override5.loaded) !== null && _requestBody$override4 !== void 0 ? _requestBody$override4 : _constants.PROGRESS_STEP_P_VALUES);
  } else {
    remainingFieldCandidates = fieldCandidates;
  }
  logDebugMessage('Fetch p-values.');
  const topTermsQueue = (0, _async.queue)(async function (fieldCandidate) {
    stateHandler.loaded(1 / fieldCandidatesCount * loadingStepSizeTopTerms, false);
    let fetchedTopTerms;
    try {
      fetchedTopTerms = await (0, _fetch_top_terms.fetchTopTerms)(client, requestBody, [fieldCandidate], logger, stateHandler.sampleProbability(), responseStream.pushError, abortSignal);
    } catch (e) {
      if (!(0, _is_request_aborted_error.isRequestAbortedError)(e)) {
        logger.error(`Failed to fetch p-values for '${fieldCandidate}', got: \n${e.toString()}`);
        responseStream.pushError(`Failed to fetch p-values for '${fieldCandidate}'.`);
      }
      return;
    }
    remainingFieldCandidates = remainingFieldCandidates.filter(d => d !== fieldCandidate);
    if (fetchedTopTerms.length > 0) {
      fetchedTopTerms.forEach(d => {
        fieldsToSample.add(d.fieldName);
      });
      topTerms.push(...fetchedTopTerms);
      responseStream.push((0, _stream_reducer.addSignificantItems)(fetchedTopTerms));
    }
    responseStream.push((0, _stream_reducer.updateLoadingState)({
      ccsWarning: false,
      loaded: stateHandler.loaded(),
      loadingState: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.loadingState.identifiedFieldValuePairs', {
        defaultMessage: 'Identified {fieldValuePairsCount, plural, one {# significant field/value pair} other {# significant field/value pairs}}.',
        values: {
          fieldValuePairsCount
        }
      }),
      remainingFieldCandidates
    }));
  }, _constants.MAX_CONCURRENT_QUERIES);
  topTermsQueue.push(fieldCandidates, err => {
    if (err) {
      logger.error(`Failed to fetch p-values.', got: \n${err.toString()}`);
      responseStream.pushError(`Failed to fetch p-values.`);
      topTermsQueue.kill();
      responseStream.end();
    } else if (stateHandler.shouldStop()) {
      logDebugMessage('shouldStop fetching p-values.');
      topTermsQueue.kill();
      responseStream.end();
    }
  });
  await topTermsQueue.drain();
  fieldValuePairsCount = topCategories.length + topTerms.length;
  if (fieldValuePairsCount === 0) {
    logDebugMessage('Stopping analysis, did not find any categories or terms.');
    responseStream.endWithUpdatedLoadingState();
    return;
  }
  return {
    fieldValuePairsCount,
    significantCategories: topCategories,
    significantTerms: topTerms
  };
};
exports.topItemsHandlerFactory = topItemsHandlerFactory;