"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overallHistogramHandlerFactory = void 0;
var _fieldTypes = require("@kbn/field-types");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _constants = require("@kbn/aiops-log-rate-analysis/constants");
var _is_request_aborted_error = require("@kbn/aiops-common/is_request_aborted_error");
var _get_histogram_query = require("@kbn/aiops-log-rate-analysis/queries/get_histogram_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overallHistogramHandlerFactory = ({
  abortSignal,
  client,
  requestBody,
  logDebugMessage,
  logger,
  responseStream,
  stateHandler
}) => async () => {
  const histogramFields = [{
    fieldName: requestBody.timeFieldName,
    type: _fieldTypes.KBN_FIELD_TYPES.DATE
  }];
  logDebugMessage('Fetch overall histogram.');
  let overallTimeSeries;
  const overallHistogramQuery = (0, _get_histogram_query.getHistogramQuery)(requestBody);
  try {
    overallTimeSeries = (await (0, _mlAggUtils.fetchHistogramsForFields)(client, requestBody.index, overallHistogramQuery,
    // fields
    histogramFields,
    // samplerShardSize
    -1, undefined, abortSignal, stateHandler.sampleProbability(), _constants.RANDOM_SAMPLER_SEED))[0];
  } catch (e) {
    if (!(0, _is_request_aborted_error.isRequestAbortedError)(e)) {
      logger.error(`Failed to fetch the overall histogram data, got: \n${e.toString()}`);
      responseStream.pushError(`Failed to fetch overall histogram data.`);
    }
    // Still continue the analysis even if loading the overall histogram fails.
  }
  if (stateHandler.shouldStop()) {
    logDebugMessage('shouldStop after fetching overall histogram.');
    responseStream.end();
    return;
  }
  return overallTimeSeries;
};
exports.overallHistogramHandlerFactory = overallHistogramHandlerFactory;