"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAiopsUiActions = registerAiopsUiActions;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _ui_actions = require("@kbn/ml-ui-actions/src/aiops/ui_actions");
var _create_change_point_chart = require("./create_change_point_chart");
var _open_change_point_ml = require("./open_change_point_ml");
var _log_categorization = require("../components/log_categorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAiopsUiActions(uiActions, coreStart, pluginStart) {
  const openChangePointInMlAppAction = (0, _open_change_point_ml.createOpenChangePointInMlAppAction)(coreStart, pluginStart);
  const addChangePointChartAction = (0, _create_change_point_chart.createAddChangePointChartAction)(coreStart, pluginStart);
  uiActions.addTriggerAction(_public.ADD_PANEL_TRIGGER, addChangePointChartAction);
  uiActions.registerTrigger(_ui_actions.categorizeFieldTrigger);
  uiActions.addTriggerAction(_ui_actions.CATEGORIZE_FIELD_TRIGGER, (0, _log_categorization.createCategorizeFieldAction)(coreStart, pluginStart));
  uiActions.addTriggerAction(_public2.CONTEXT_MENU_TRIGGER, openChangePointInMlAppAction);
}