"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesModal = void 0;
var _react = require("react");
var _mlStringHash = require("@kbn/ml-string-hash");
var _common = require("@kbn/cases-plugin/common");
var _use_aiops_app_context = require("./use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a callback for opening the cases modal with provided attachment state.
 */
const useCasesModal = embeddableType => {
  const {
    cases
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const selectCaseModal = cases === null || cases === void 0 ? void 0 : cases.hooks.useCasesAddToExistingCaseModal();
  return (0, _react.useCallback)(persistableState => {
    const persistableStateAttachmentState = {
      ...persistableState,
      // Creates unique id based on the input
      id: (0, _mlStringHash.stringHash)(JSON.stringify(persistableState)).toString()
    };
    if (!selectCaseModal) {
      throw new Error('Cases modal is not available');
    }
    selectCaseModal.open({
      getAttachments: () => [{
        type: _common.AttachmentType.persistableState,
        persistableStateAttachmentTypeId: embeddableType,
        persistableStateAttachmentState: JSON.parse(JSON.stringify(persistableStateAttachmentState))
      }]
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [embeddableType]);
};
exports.useCasesModal = useCasesModal;