"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableChangePointUserInput = resolveEmbeddableChangePointUserInput;
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _change_point_chart_initializer = require("./change_point_chart_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableChangePointUserInput(coreStart, pluginStart, parentApi, focusedPanelId, input) {
  const {
    overlays
  } = coreStart;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  return new Promise(async (resolve, reject) => {
    try {
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
        value: {
          ...coreStart,
          ...pluginStart
        }
      }, /*#__PURE__*/_react.default.createElement(_change_point_chart_initializer.ChangePointChartInitializer, {
        initialInput: input,
        onCreate: update => {
          resolve(update);
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        },
        onCancel: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      })), coreStart), {
        ownFocus: true,
        size: 's',
        type: 'push',
        'data-test-subj': 'aiopsChangePointChartEmbeddableInitializer',
        'aria-labelledby': 'changePointConfig',
        onClose: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      });
      if ((0, _presentationContainers.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}