"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaselineAndDeviationRates = getBaselineAndDeviationRates;
exports.getLogRateChange = getLogRateChange;
var _i18n = require("@kbn/i18n");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLogRateChange(analysisType, baselineBucketRate, deviationBucketRate) {
  let message;
  let factor;
  if (analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE) {
    if (baselineBucketRate > 0) {
      factor = Math.round(deviationBucketRate / baselineBucketRate * 100 / 100);
      message = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateFactorIncreaseLabel', {
        defaultMessage: '{factor}x higher',
        values: {
          factor
        }
      });
    } else {
      message = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateDocIncreaseLabel', {
        defaultMessage: '{deviationBucketRate} {deviationBucketRate, plural, one {doc} other {docs}} rate up from 0 in baseline',
        values: {
          deviationBucketRate
        }
      });
    }
  } else {
    if (deviationBucketRate > 0) {
      // For dip, "doc count" refers to the amount of documents in the baseline time range so we use baselineBucketRate
      factor = Math.round(baselineBucketRate / deviationBucketRate * 100 / 100);
      message = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateFactorDecreaseLabel', {
        defaultMessage: '{factor}x lower',
        values: {
          factor
        }
      });
    } else {
      message = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTableGroups.logRateDocDecreaseLabel', {
        defaultMessage: 'docs rate down to 0 from {baselineBucketRate} in baseline',
        values: {
          baselineBucketRate
        }
      });
    }
  }
  return {
    message,
    factor
  };
}
function getBaselineAndDeviationRates(analysisType, baselineBuckets, deviationBuckets, docCount, bgCount) {
  let baselineBucketRate;
  let deviationBucketRate;
  if (analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE) {
    if (bgCount !== undefined) {
      baselineBucketRate = Math.round(bgCount / baselineBuckets);
    }
    if (docCount !== undefined) {
      deviationBucketRate = Math.round(docCount / deviationBuckets);
    }
  } else {
    // For dip, the "doc count" refers to the amount of documents in the baseline time range so we set baselineBucketRate
    if (docCount !== undefined) {
      baselineBucketRate = Math.round(docCount / baselineBuckets);
    }
    if (bgCount !== undefined) {
      deviationBucketRate = Math.round(bgCount / deviationBuckets);
    }
  }
  return {
    baselineBucketRate,
    deviationBucketRate
  };
}