"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisTypeCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogRateAnalysisTypeCallOut = ({
  analysisType
}) => {
  const zeroDocsFallback = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.zeroDocsFallback);
  let callOutTitle;
  let callOutText;
  if (!zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE) {
    callOutTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeCallOutTitle', {
      defaultMessage: 'Analysis type: Log rate spike'
    });
    callOutText = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeCallOutContent', {
      defaultMessage: 'The median log rate in the selected deviation time range is higher than the baseline. Therefore, the analysis results table shows statistically significant items within the deviation time range that are contributors to the spike. The "doc count" column refers to the amount of documents in the deviation time range.'
    });
  } else if (!zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP) {
    callOutTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipCallOutTitle', {
      defaultMessage: 'Analysis type: Log rate dip'
    });
    callOutText = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipCallOutContent', {
      defaultMessage: 'The median log rate in the selected deviation time range is lower than the baseline. Therefore, the analysis results table shows statistically significant items within the baseline time range that are less in number or missing within the deviation time range. The "doc count" column refers to the amount of documents in the baseline time range.'
    });
  } else if (zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE) {
    callOutTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeFallbackCallOutTitle', {
      defaultMessage: 'Analysis type: Top items for deviation time range'
    });
    callOutText = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeSpikeCallOutContentFallback', {
      defaultMessage: 'The baseline time range does not contain any documents. Therefore the results show top log message categories and field values for the deviation time range.'
    });
  } else if (zeroDocsFallback && analysisType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP) {
    callOutTitle = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipFallbackCallOutTitle', {
      defaultMessage: 'Analysis type: Top items for baseline time range'
    });
    callOutText = _i18n.i18n.translate('xpack.aiops.analysis.analysisTypeDipCallOutContentFallback', {
      defaultMessage: 'The deviation time range does not contain any documents. Therefore the results show top log message categories and field values for the baseline time range.'
    });
  } else {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "aiopsAnalysisTypeCalloutTitle"
    }, callOutTitle),
    color: "primary",
    iconType: "pin",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, callOutText));
};
exports.LogRateAnalysisTypeCallOut = LogRateAnalysisTypeCallOut;