"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidateFieldRequest = useValidateFieldRequest;
var _react = require("react");
var _constants = require("@kbn/aiops-common/constants");
var _create_categorize_query = require("@kbn/aiops-log-pattern-analysis/create_categorize_query");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useValidateFieldRequest() {
  const {
    http
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const abortController = (0, _react.useRef)(new AbortController());
  const runValidateFieldRequest = (0, _react.useCallback)(async (index, field, timeField, timeRange, queryIn, runtimeMappings, headers) => {
    const query = (0, _create_categorize_query.createCategorizeQuery)(queryIn, timeField, timeRange);
    const resp = await http.post(_constants.AIOPS_API_ENDPOINT.CATEGORIZATION_FIELD_VALIDATION, {
      body: JSON.stringify({
        indexPatternTitle: index,
        query,
        size: 5,
        field,
        timeField,
        start: timeRange.from,
        end: timeRange.to,
        runtimeMappings,
        indicesOptions: undefined,
        includeExamples: false
      }),
      headers,
      version: '1',
      signal: abortController.current.signal
    });
    return resp;
  }, [http]);
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController();
  }, []);
  return {
    runValidateFieldRequest,
    cancelRequest
  };
}