"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showCategorizeFlyout = showCategorizeFlyout;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public3 = require("@kbn/data-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _log_categorization_for_flyout = require("./log_categorization_for_flyout");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _storage = require("../../types/storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);
async function showCategorizeFlyout(field, dataView, coreStart, plugins, originatingApp, additionalFilter) {
  const {
    overlays,
    application,
    i18n
  } = coreStart;
  return new Promise(async (resolve, reject) => {
    try {
      const onFlyoutClose = () => {
        flyoutSession.close();
        resolve();
      };
      const appDependencies = {
        ...coreStart,
        ...plugins
      };
      const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme');
      const datePickerDeps = {
        ...(0, _lodash.pick)(appDependencies, ['data', 'http', 'notifications', 'theme', 'uiSettings']),
        i18n,
        uiSettingsKeys: _public3.UI_SETTINGS
      };
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
        services: {
          ...coreStart
        }
      }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
        value: appDependencies
      }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
        storage: localStorage,
        storageKeys: _storage.AIOPS_STORAGE_KEYS
      }, /*#__PURE__*/_react.default.createElement(_log_categorization_for_flyout.LogCategorizationFlyout, {
        dataView: dataView,
        savedSearch: null,
        selectedField: field,
        onClose: onFlyoutClose,
        embeddingOrigin: originatingApp,
        additionalFilter: additionalFilter
      }))))), startServices), {
        'data-test-subj': 'aiopsCategorizeFlyout',
        ownFocus: true,
        closeButtonProps: {
          'aria-label': 'aiopsCategorizeFlyout'
        },
        onClose: onFlyoutClose,
        size: 'l'
      });

      // Close the flyout when user navigates out of the current plugin
      application.currentAppId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.takeUntil)((0, _rxjs.from)(flyoutSession.onClose)), (0, _rxjs.distinctUntilChanged)()).subscribe(() => {
        flyoutSession.close();
      });
    } catch (error) {
      reject(error);
    }
  });
}