"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SamplingPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _random_sampler_range_slider = require("./random_sampler_range_slider");
var _random_sampler = require("./random_sampler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SamplingPanel = ({
  randomSampler,
  reload,
  calloutPosition = 'top'
}) => {
  const samplingProbability = (0, _useObservable.default)(randomSampler.getProbability$(), randomSampler.getProbability());
  const setSamplingProbability = (0, _react.useCallback)(probability => {
    randomSampler.setProbability(probability);
    reload();
  }, [reload, randomSampler]);
  const randomSamplerPreference = (0, _useObservable.default)(randomSampler.getMode$(), randomSampler.getMode());
  const setRandomSamplerPreference = (0, _react.useCallback)(mode => {
    randomSampler.setMode(mode);
    reload();
  }, [randomSampler, reload]);
  const {
    calloutInfoMessage
  } = (0, _react.useMemo)(() => (0, _random_sampler.randomSamplerText)(randomSamplerPreference), [randomSamplerPreference]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, calloutPosition === 'top' ? /*#__PURE__*/_react.default.createElement(CalloutInfoMessage, {
    calloutInfoMessage: calloutInfoMessage,
    calloutPosition: calloutPosition
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "aiopsRandomSamplerOptionsFormRow",
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.randomSamplerSettingsPopUp.randomSamplerRowLabel', {
      defaultMessage: 'Random sampling'
    }),
    helpText: randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC ? /*#__PURE__*/_react.default.createElement(ProbabilityUsedMessage, {
      samplingProbability: samplingProbability
    }) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "aiopsRandomSamplerOptionsSelect",
    options: _random_sampler.RANDOM_SAMPLER_SELECT_OPTIONS,
    valueOfSelected: randomSamplerPreference,
    onChange: setRandomSamplerPreference
  })), randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL ? /*#__PURE__*/_react.default.createElement(_random_sampler_range_slider.RandomSamplerRangeSlider, {
    samplingProbability: samplingProbability,
    setSamplingProbability: setSamplingProbability
  }) : null, calloutPosition === 'bottom' ? /*#__PURE__*/_react.default.createElement(CalloutInfoMessage, {
    calloutInfoMessage: calloutInfoMessage,
    calloutPosition: calloutPosition
  }) : null);
};
exports.SamplingPanel = SamplingPanel;
const ProbabilityUsedMessage = ({
  samplingProbability
}) => {
  return samplingProbability !== null ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiopsRandomSamplerProbabilityUsedMsg"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.randomSamplerSettingsPopUp.probabilityLabel",
    defaultMessage: "Probability used: {samplingProbability}%",
    values: {
      samplingProbability: Number((samplingProbability * 100).toPrecision(3))
    }
  })) : null;
};
const CalloutInfoMessage = ({
  calloutInfoMessage,
  calloutPosition
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, calloutPosition === 'bottom' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  size: "s",
  color: 'primary',
  title: calloutInfoMessage
}), calloutPosition === 'top' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}) : null);