"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sampling_panel = require("../sampling_menu/sampling_panel");
var _minimum_time_range = require("./minimum_time_range");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const minimumTimeRangeOptions = Object.keys(_minimum_time_range.MINIMUM_TIME_RANGE).map(value => ({
  inputDisplay: value,
  value: value
}));
const EmbeddableMenu = ({
  randomSampler,
  minimumTimeRangeOption,
  setMinimumTimeRangeOption,
  categoryCount,
  reload
}) => {
  const [showMenu, setShowMenu] = (0, _react.useState)(false);
  const togglePopover = () => setShowMenu(!showMenu);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.tooltip', {
      defaultMessage: 'Options'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "aiopsEmbeddableMenuOptionsButton",
    size: "s",
    iconType: "controlsHorizontal",
    onClick: () => togglePopover()
    // @ts-ignore - subdued does work
    ,
    color: "subdued",
    "aria-label": _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.aria', {
      defaultMessage: 'Pattern analysis options'
    })
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: 'embeddableMenu',
    button: button,
    isOpen: showMenu,
    closePopover: () => togglePopover(),
    panelPaddingSize: "s",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    css: {
      maxWidth: '400px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.embeddableMenu.patternAnalysisSettingsTitle",
    defaultMessage: " Pattern analysis settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "aiopsRandomSamplerOptionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        textWrap: 'nowrap'
      }
    }, _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.minimumTimeRangeOptionsRowLabel', {
      defaultMessage: 'Minimum time range'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.minimumTimeRange.tooltip', {
        defaultMessage: 'Adds a wider time range to the analysis to improve pattern accuracy.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued"
    })))),
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, categoryCount !== undefined && minimumTimeRangeOption !== 'No minimum' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logCategorization.embeddableMenu.totalPatternsMessage",
      defaultMessage: "Total patterns in {minimumTimeRangeOption}: {categoryCount}",
      values: {
        minimumTimeRangeOption,
        categoryCount
      }
    })) : null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "aria-label": "Select a minimum time range",
    options: minimumTimeRangeOptions,
    valueOfSelected: minimumTimeRangeOption,
    onChange: setMinimumTimeRangeOption
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_sampling_panel.SamplingPanel, {
    randomSampler: randomSampler,
    reload: reload,
    calloutPosition: "bottom"
  })));
};
exports.EmbeddableMenu = EmbeddableMenu;