"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _embeddable_menu = require("./embeddable_menu");
var _selected_patterns = require("./selected_patterns");
var _create_categorization_job = require("../create_categorization_job");
var _field_selector = require("./field_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DiscoverTabs = ({
  renderViewModeToggle,
  randomSampler,
  openInDiscover,
  selectedCategories,
  loadCategories,
  fields,
  setSelectedField,
  selectedField,
  minimumTimeRangeOption,
  setMinimumTimeRangeOption,
  data,
  dataview,
  earliest,
  latest,
  query
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderViewModeToggle(data === null || data === void 0 ? void 0 : data.categories.length)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, selectedCategories.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_selected_patterns.SelectedPatterns, {
    openInDiscover: openInDiscover
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_selector.SelectedField, {
    fields: fields,
    setSelectedField: setSelectedField,
    selectedField: selectedField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTableToolbarControlGroup",
    css: {
      marginRight: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTableToolbarControlIconButton"
  }, /*#__PURE__*/_react.default.createElement(_embeddable_menu.EmbeddableMenu, {
    randomSampler: randomSampler,
    reload: () => loadCategories(),
    minimumTimeRangeOption: minimumTimeRangeOption,
    setMinimumTimeRangeOption: setMinimumTimeRangeOption,
    categoryCount: data === null || data === void 0 ? void 0 : data.totalCategories
  })), selectedField !== null && earliest !== undefined && latest !== undefined ? /*#__PURE__*/_react.default.createElement("div", {
    className: "unifiedDataTableToolbarControlIconButton"
  }, /*#__PURE__*/_react.default.createElement(_create_categorization_job.CreateCategorizationJobButton, {
    dataView: dataview,
    field: selectedField,
    query: query,
    earliest: earliest,
    latest: latest,
    iconOnly: true
  })) : null)))))));
};
exports.DiscoverTabs = DiscoverTabs;