"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOpenInDiscover = useOpenInDiscover;
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _use_discover_links = require("../use_discover_links");
var _labels = require("./labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useOpenInDiscover(dataViewId, selectedField, selectedCategories, aiopsListState, timefilter, navigateToDiscover, onAddFilter, additionalFilter, onClose = () => {}) {
  const {
    openInDiscoverWithFilter
  } = (0, _use_discover_links.useDiscoverLinks)();
  const openFunction = (0, _react.useCallback)((mode, category) => {
    if (onAddFilter !== undefined && selectedField !== undefined && typeof selectedField !== 'string' && navigateToDiscover === false) {
      onAddFilter((0, _use_discover_links.createFilter)('', selectedField.name, selectedCategories, mode, category), `Patterns - ${selectedField.name}`);
      onClose();
      return;
    }
    const timefilterActiveBounds = additionalFilter !== undefined ? {
      min: (0, _moment.default)(additionalFilter.from),
      max: (0, _moment.default)(additionalFilter.to)
    } : timefilter.getActiveBounds();
    if (timefilterActiveBounds === undefined || selectedField === undefined) {
      return;
    }
    openInDiscoverWithFilter(dataViewId, typeof selectedField === 'string' ? selectedField : selectedField.name, selectedCategories, aiopsListState, timefilterActiveBounds, mode, category, additionalFilter === null || additionalFilter === void 0 ? void 0 : additionalFilter.field);
  }, [onAddFilter, selectedField, navigateToDiscover, additionalFilter, timefilter, openInDiscoverWithFilter, dataViewId, selectedCategories, aiopsListState, onClose]);
  const labels = (0, _react.useMemo)(() => {
    const isFlyout = onAddFilter !== undefined && onClose !== undefined;
    return (0, _labels.getLabels)(isFlyout && navigateToDiscover === false);
  }, [navigateToDiscover, onAddFilter, onClose]);
  return {
    openFunction,
    labels,
    count: selectedCategories.length
  };
}