"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionAppState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _eui = require("@elastic/eui");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _constants = require("@kbn/aiops-common/constants");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _storage = require("../../types/storage");
var _page_header = require("../page_header");
var _change_point_detection_page = require("./change_point_detection_page");
var _change_point_detection_context = require("./change_point_detection_context");
var _time_series_dataview_check = require("../../application/utils/time_series_dataview_check");
var _use_reload = require("../../hooks/use_reload");
var _use_filters_query = require("../../hooks/use_filters_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);

/**
 * Props for the ChangePointDetectionAppState component.
 */

const ChangePointDetectionAppState = ({
  dataView,
  savedSearch,
  appDependencies,
  showFrozenDataTierChoice = true
}) => {
  var _appDependencies$pres, _appDependencies$pres2, _appDependencies$case, _appDependencies$case2, _appDependencies$case3;
  const datePickerDeps = {
    ...(0, _lodash.pick)(appDependencies, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  const warning = (0, _time_series_dataview_check.timeSeriesDataViewWarning)(dataView, 'change_point_detection');
  const reload$ = (0, _react.useMemo)(() => {
    return _mlDatePicker.mlTimefilterRefresh$.pipe((0, _rxjs.map)(v => v.lastRefresh));
  }, []);
  if (warning !== null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warning);
  }
  appDependencies.embeddingOrigin = _constants.AIOPS_TELEMETRY_ID.AIOPS_DEFAULT_SOURCE;
  const PresentationContextProvider = (_appDependencies$pres = (_appDependencies$pres2 = appDependencies.presentationUtil) === null || _appDependencies$pres2 === void 0 ? void 0 : _appDependencies$pres2.ContextProvider) !== null && _appDependencies$pres !== void 0 ? _appDependencies$pres : _react.default.Fragment;
  const CasesContext = (_appDependencies$case = (_appDependencies$case2 = appDependencies.cases) === null || _appDependencies$case2 === void 0 ? void 0 : _appDependencies$case2.ui.getCasesContext()) !== null && _appDependencies$case !== void 0 ? _appDependencies$case : _react.default.Fragment;
  const casesPermissions = (_appDependencies$case3 = appDependencies.cases) === null || _appDependencies$case3 === void 0 ? void 0 : _appDependencies$case3.helpers.canUseCases();
  return /*#__PURE__*/_react.default.createElement(PresentationContextProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: appDependencies.theme
  }, /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [],
    permissions: casesPermissions
  }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appDependencies
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: reload$
  }, /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, null, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionContextProvider, null, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, null, /*#__PURE__*/_react.default.createElement(_change_point_detection_page.ChangePointDetectionPage, null)))))))))))));
};
exports.ChangePointDetectionAppState = ChangePointDetectionAppState;