"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionControlsContextProvider = exports.ChangePointDetectionControlsContext = exports.ChangePointDetectionContextProvider = exports.ChangePointDetectionContext = void 0;
exports.useChangePointDetectionContext = useChangePointDetectionContext;
exports.useChangePointDetectionControlsContext = void 0;
exports.useRequestParams = useRequestParams;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _fieldTypes = require("@kbn/field-types");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _use_filters_query = require("../../hooks/use_filters_query");
var _constants = require("./constants");
var _search_utils = require("../../application/utils/search_utils");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangePointDetectionContext = exports.ChangePointDetectionContext = /*#__PURE__*/(0, _react.createContext)({
  splitFieldsOptions: [],
  metricFieldOptions: [],
  requestParams: {},
  timeBuckets: {},
  bucketInterval: {},
  updateRequestParams: () => {},
  resultFilters: [],
  updateFilters: () => {},
  resultQuery: {
    query: '',
    language: 'kuery'
  },
  combinedQuery: {},
  selectedChangePoints: {},
  setSelectedChangePoints: () => {}
});
const ChangePointDetectionControlsContext = exports.ChangePointDetectionControlsContext = /*#__PURE__*/(0, _react.createContext)({
  splitFieldsOptions: [],
  metricFieldOptions: []
});
const useChangePointDetectionControlsContext = () => {
  return (0, _react.useContext)(ChangePointDetectionControlsContext);
};
exports.useChangePointDetectionControlsContext = useChangePointDetectionControlsContext;
const ChangePointDetectionControlsContextProvider = ({
  children
}) => {
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const metricFieldOptions = (0, _react.useMemo)(() => {
    return dataView.fields.filter(({
      aggregatable,
      type
    }) => aggregatable && type === 'number');
  }, [dataView]);
  const splitFieldsOptions = (0, _react.useMemo)(() => {
    return dataView.fields.filter(({
      aggregatable,
      esTypes,
      displayName
    }) => aggregatable && esTypes && esTypes.some(el => [_fieldTypes.ES_FIELD_TYPES.KEYWORD, _fieldTypes.ES_FIELD_TYPES.IP].includes(el)) && !['_id', '_index'].includes(displayName));
  }, [dataView]);
  const value = {
    metricFieldOptions,
    splitFieldsOptions
  };
  return /*#__PURE__*/_react.default.createElement(ChangePointDetectionControlsContext.Provider, {
    value: value
  }, children);
};
exports.ChangePointDetectionControlsContextProvider = ChangePointDetectionControlsContextProvider;
const ChangePointDetectionContextProvider = ({
  children
}) => {
  const {
    dataView,
    savedSearch
  } = (0, _use_data_source.useDataSource)();
  const {
    uiSettings,
    data: {
      query: {
        filterManager,
        queryString
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const savedSearchQuery = (0, _react.useMemo)(() => {
    return (0, _search_utils.getEsQueryFromSavedSearch)({
      dataView,
      uiSettings,
      savedSearch,
      filterManager
    });
  }, [dataView, savedSearch, uiSettings, filterManager]);
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const {
    searchBounds
  } = (0, _use_filters_query.useFilterQueryUpdates)();
  const [resultFilters, setResultFilter] = (0, _react.useState)([]);
  const [selectedChangePoints, setSelectedChangePoints] = (0, _react.useState)({});
  const [bucketInterval, setBucketInterval] = (0, _react.useState)();
  (0, _react.useEffect)(function updateIntervalOnTimeBoundsChange() {
    const timeUpdateSubscription = timefilter.getTimeUpdate$().pipe((0, _rxjs.startWith)(timefilter.getTime())).subscribe(() => {
      const activeBounds = timefilter.getActiveBounds();
      if (!activeBounds) {
        throw new Error('Time bound not available');
      }
      timeBuckets.setInterval('auto');
      timeBuckets.setBounds(activeBounds);
      setBucketInterval(timeBuckets.getInterval());
    });
    return () => {
      timeUpdateSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const metricFieldOptions = (0, _react.useMemo)(() => {
    return dataView.fields.filter(({
      aggregatable,
      type
    }) => aggregatable && type === 'number');
  }, [dataView]);
  const splitFieldsOptions = (0, _react.useMemo)(() => {
    return dataView.fields.filter(({
      aggregatable,
      esTypes,
      displayName
    }) => aggregatable && esTypes && esTypes.some(el => [_fieldTypes.ES_FIELD_TYPES.KEYWORD, _fieldTypes.ES_FIELD_TYPES.IP].includes(el)) && !['_id', '_index'].includes(displayName));
  }, [dataView]);
  const [requestParamsFromUrl, updateRequestParams] = (0, _mlUrlState.usePageUrlState)('changePoint');
  const resultQuery = (0, _react.useMemo)(() => {
    var _requestParamsFromUrl, _savedSearchQuery$sea, _savedSearchQuery$que;
    return (_requestParamsFromUrl = requestParamsFromUrl.query) !== null && _requestParamsFromUrl !== void 0 ? _requestParamsFromUrl : {
      query: (_savedSearchQuery$sea = savedSearchQuery === null || savedSearchQuery === void 0 ? void 0 : savedSearchQuery.searchString) !== null && _savedSearchQuery$sea !== void 0 ? _savedSearchQuery$sea : '',
      language: (_savedSearchQuery$que = savedSearchQuery === null || savedSearchQuery === void 0 ? void 0 : savedSearchQuery.queryLanguage) !== null && _savedSearchQuery$que !== void 0 ? _savedSearchQuery$que : 'kuery'
    };
  }, [savedSearchQuery, requestParamsFromUrl.query]);
  const requestParams = (0, _react.useMemo)(() => {
    const params = {
      ...requestParamsFromUrl
    };
    if (!params.fieldConfigs) {
      var _metricFieldOptions$;
      params.fieldConfigs = [{
        fn: _constants.DEFAULT_AGG_FUNCTION,
        metricField: (_metricFieldOptions$ = metricFieldOptions[0]) === null || _metricFieldOptions$ === void 0 ? void 0 : _metricFieldOptions$.name
      }];
    }
    params.interval = bucketInterval === null || bucketInterval === void 0 ? void 0 : bucketInterval.expression;
    return params;
  }, [requestParamsFromUrl, metricFieldOptions, bucketInterval]);
  const updateFilters = (0, _react.useCallback)(update => {
    filterManager.setFilters(update);
  }, [filterManager]);
  (0, _react.useEffect)(() => {
    setResultFilter(filterManager.getFilters());
    const sub = filterManager.getUpdates$().subscribe(() => {
      setResultFilter(filterManager.getFilters());
    });
    return () => {
      sub.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function syncFilters() {
    const globalFilters = filterManager === null || filterManager === void 0 ? void 0 : filterManager.getGlobalFilters();
    if (requestParamsFromUrl.filters) {
      filterManager.setFilters(requestParamsFromUrl.filters);
    }
    if (requestParamsFromUrl.query) {
      queryString.setQuery(requestParamsFromUrl.query);
    }
    if (globalFilters) {
      filterManager === null || filterManager === void 0 ? void 0 : filterManager.addFilters(globalFilters);
    }
    return () => {
      filterManager === null || filterManager === void 0 ? void 0 : filterManager.removeAll();
      queryString.clearQuery();
    };
  }, [requestParamsFromUrl.filters, requestParamsFromUrl.query, filterManager, queryString]);
  const combinedQuery = (0, _react.useMemo)(() => {
    var _mergedQuery$bool, _searchBounds$min, _searchBounds$max;
    const mergedQuery = (0, _search_utils.createMergedEsQuery)(resultQuery, resultFilters, dataView, uiSettings);
    if (!Array.isArray((_mergedQuery$bool = mergedQuery.bool) === null || _mergedQuery$bool === void 0 ? void 0 : _mergedQuery$bool.filter)) {
      if (!mergedQuery.bool) {
        mergedQuery.bool = {};
      }
      mergedQuery.bool.filter = [];
    }
    mergedQuery.bool.filter.push({
      range: {
        [dataView.timeFieldName]: {
          from: (_searchBounds$min = searchBounds.min) === null || _searchBounds$min === void 0 ? void 0 : _searchBounds$min.valueOf(),
          to: (_searchBounds$max = searchBounds.max) === null || _searchBounds$max === void 0 ? void 0 : _searchBounds$max.valueOf()
        }
      }
    });
    return mergedQuery;
  }, [resultFilters, resultQuery, uiSettings, dataView, searchBounds]);
  if (!bucketInterval) return null;
  const value = {
    timeBuckets,
    requestParams,
    updateRequestParams,
    metricFieldOptions,
    splitFieldsOptions,
    bucketInterval,
    resultFilters,
    updateFilters,
    resultQuery,
    combinedQuery,
    selectedChangePoints,
    setSelectedChangePoints
  };
  return /*#__PURE__*/_react.default.createElement(ChangePointDetectionContext.Provider, {
    value: value
  }, children);
};
exports.ChangePointDetectionContextProvider = ChangePointDetectionContextProvider;
function useChangePointDetectionContext() {
  return (0, _react.useContext)(ChangePointDetectionContext);
}
function useRequestParams() {
  return useChangePointDetectionContext().requestParams;
}