"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentSelectedSignificantItem = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectSelectedSignificantItem = s => s.logRateAnalysisTableRow.selectedSignificantItem;
const selectPinnedSignificantItem = s => s.logRateAnalysisTableRow.pinnedSignificantItem;
const selectCurrentSelectedSignificantItem = (0, _toolkit.createSelector)(selectSelectedSignificantItem, selectPinnedSignificantItem, (selectedSignificantItem, pinnedSignificantItem) => {
  if (selectedSignificantItem) {
    return selectedSignificantItem;
  } else if (pinnedSignificantItem) {
    return pinnedSignificantItem;
  }
});
const useCurrentSelectedSignificantItem = () => (0, _hooks.useAppSelector)(selectCurrentSelectedSignificantItem);
exports.useCurrentSelectedSignificantItem = useCurrentSelectedSignificantItem;