"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setSelectedSignificantItem = exports.setSelectedGroup = exports.setPinnedSignificantItem = exports.setPinnedGroup = exports.logRateAnalysisTableRowSlice = exports.clearAllRowState = void 0;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultState() {
  return {
    pinnedGroup: null,
    pinnedSignificantItem: null,
    selectedGroup: null,
    selectedSignificantItem: null
  };
}
const logRateAnalysisTableRowSlice = exports.logRateAnalysisTableRowSlice = (0, _toolkit.createSlice)({
  name: 'logRateAnalysisTableRow',
  initialState: getDefaultState(),
  reducers: {
    clearAllRowState: state => {
      state.pinnedGroup = null;
      state.pinnedSignificantItem = null;
      state.selectedGroup = null;
      state.selectedSignificantItem = null;
    },
    setPinnedGroup: (state, action) => {
      state.pinnedGroup = action.payload;
    },
    setPinnedSignificantItem: (state, action) => {
      state.pinnedSignificantItem = action.payload;
    },
    setSelectedGroup: (state, action) => {
      state.selectedGroup = action.payload;
    },
    setSelectedSignificantItem: (state, action) => {
      state.selectedSignificantItem = action.payload;
    }
  }
});

// Action creators are generated for each case reducer function
const {
  clearAllRowState,
  setPinnedGroup,
  setPinnedSignificantItem,
  setSelectedGroup,
  setSelectedSignificantItem
} = logRateAnalysisTableRowSlice.actions;
exports.setSelectedSignificantItem = setSelectedSignificantItem;
exports.setSelectedGroup = setSelectedGroup;
exports.setPinnedSignificantItem = setPinnedSignificantItem;
exports.setPinnedGroup = setPinnedGroup;
exports.clearAllRowState = clearAllRowState;