"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogRateAnalysisType = getLogRateAnalysisType;
var _d3Array = require("d3-array");
var _log_rate_analysis_type = require("./log_rate_analysis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Identify the log rate analysis type based on the baseline/deviation
 * time ranges on a given log rate histogram.
 *
 * @param logRateHistogram The log rate histogram.
 * @param windowParameters The window parameters with baseline and deviation time range.
 * @returns The log rate analysis type.
 */
function getLogRateAnalysisType(logRateHistogram, windowParameters) {
  var _median, _median2;
  const {
    baselineMin,
    baselineMax,
    deviationMin,
    deviationMax
  } = windowParameters;
  const baselineItems = logRateHistogram.filter(d => d.time >= baselineMin && d.time < baselineMax);
  const baselineMedian = (_median = (0, _d3Array.median)(baselineItems.map(d => d.value))) !== null && _median !== void 0 ? _median : 0;
  const deviationItems = logRateHistogram.filter(d => d.time >= deviationMin && d.time < deviationMax);
  const deviationMedian = (_median2 = (0, _d3Array.median)(deviationItems.map(d => d.value))) !== null && _median2 !== void 0 ? _median2 : 0;
  return deviationMedian >= baselineMedian ? _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE : _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.DIP;
}