"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMBEDDABLE_ORIGIN = exports.AIOPS_TELEMETRY_ID = exports.AIOPS_PLUGIN_ID = exports.AIOPS_API_ENDPOINT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * AIOPS_PLUGIN_ID is used as a unique identifier for the aiops plugin
 */
const AIOPS_PLUGIN_ID = exports.AIOPS_PLUGIN_ID = 'aiops';
const AIOPS_API_ENDPOINT = exports.AIOPS_API_ENDPOINT = {
  LOG_RATE_ANALYSIS: '/internal/aiops/log_rate_analysis',
  CATEGORIZATION_FIELD_VALIDATION: '/internal/aiops/categorization_field_validation'
};
const AIOPS_TELEMETRY_ID = exports.AIOPS_TELEMETRY_ID = {
  AIOPS_DEFAULT_SOURCE: 'ml_aiops_labs',
  AIOPS_ANALYSIS_RUN_ORIGIN: 'aiops-analysis-run-origin'
};
const EMBEDDABLE_ORIGIN = exports.EMBEDDABLE_ORIGIN = 'embeddable';