"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MakePartsList = void 0;
var ecma402_abstract_1 = require("@formatjs/ecma402-abstract");
function MakePartsList(pattern, unit, parts) {
    var patternParts = (0, ecma402_abstract_1.PartitionPattern)(pattern);
    var result = [];
    for (var _i = 0, patternParts_1 = patternParts; _i < patternParts_1.length; _i++) {
        var patternPart = patternParts_1[_i];
        if (patternPart.type === 'literal') {
            result.push({
                type: 'literal',
                value: patternPart.value,
            });
        }
        else {
            (0, ecma402_abstract_1.invariant)(patternPart.type === '0', "Malformed pattern ".concat(pattern));
            for (var _a = 0, parts_1 = parts; _a < parts_1.length; _a++) {
                var part = parts_1[_a];
                result.push({
                    type: part.type,
                    value: part.value,
                    unit: unit,
                });
            }
        }
    }
    return result;
}
exports.MakePartsList = MakePartsList;
