"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeepEqual = void 0;
var _react = require("react");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This hook is mostly a performance concern for third-party objs/arrays that EUI
 * has no control over and may not be correctly memoized (i.e., will create a new
 * reference on every rerender unless passed through this hook).
 */
var useDeepEqual = exports.useDeepEqual = function useDeepEqual(object) {
  var ref = (0, _react.useRef)(object);
  if (!(0, _isEqual.default)(object, ref.current)) {
    ref.current = object;
  }
  return ref.current;
};