"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiToolTipStyles = exports.euiToolTipBorderColor = exports.euiToolTipBackgroundColor = exports.euiToolTipAnchorStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _amsterdam = require("../../themes/amsterdam");
var _templateObject, _templateObject2;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiToolTipBackgroundColor = exports.euiToolTipBackgroundColor = function euiToolTipBackgroundColor(euiTheme, colorMode) {
  return colorMode === _services.COLOR_MODES_STANDARD.dark ? (0, _services.shade)(euiTheme.colors.emptyShade, 1) : (0, _services.tint)(euiTheme.colors.fullShade, 0.25);
};
var euiToolTipBorderColor = exports.euiToolTipBorderColor = function euiToolTipBorderColor(euiTheme, colorMode) {
  return colorMode === _services.COLOR_MODES_STANDARD.dark ? (0, _services.shade)(euiTheme.colors.fullShade, 0.8) : (0, _services.tint)(euiTheme.colors.fullShade, 0.35);
};
var euiToolTipAnimationVertical = function euiToolTipAnimationVertical(size) {
  return (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n    0% {\n        opacity: 0;\n        transform: translateY(", ");\n    }\n\n    100% {\n        opacity: 1;\n        transform: translateY(0);\n    }\n"])), size);
};
var euiToolTipAnimationHorizontal = function euiToolTipAnimationHorizontal(size) {
  return (0, _react.keyframes)(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n    0% {\n        opacity: 0;\n        transform: translateX(", ");\n    }\n\n    100% {\n        opacity: 1;\n        transform: translateX(0);\n    }\n"])), size);
};
var euiToolTipStyles = exports.euiToolTipStyles = function euiToolTipStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var animationTiming = "".concat(euiTheme.animation.slow, " ease-out 0s forwards");
  // Shift arrow 1px more than half its size to account for border radius
  var arrowSize = euiTheme.size.m;
  var arrowPlusSize = (0, _global_styling.mathWithUnits)(arrowSize, function (x) {
    return (x / 2 + 1) * -1;
  });
  var arrowMinusSize = (0, _global_styling.mathWithUnits)(arrowSize, function (x) {
    return (x / 2 - 1) * -1;
  });
  return {
    // Base
    euiToolTip: /*#__PURE__*/(0, _react.css)((0, _amsterdam.euiShadow)(euiThemeContext), " border-radius:", euiTheme.border.radius.medium, ";background-color:", euiToolTipBackgroundColor(euiTheme, colorMode), ";color:", euiTheme.colors.ghost, ";z-index:", euiTheme.levels.toast, ";", (0, _global_styling.logicalCSS)('max-width', '256px'), " overflow-wrap:break-word;padding:", euiTheme.size.s, ";", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), " position:absolute;[class*='euiHorizontalRule']{background-color:", euiToolTipBorderColor(euiTheme, colorMode), ";};label:euiToolTip;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";;label:s;"),
    // Positions
    top: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiToolTipAnimationVertical("-".concat(euiTheme.size.base)), " ", animationTiming, ";};label:top;"),
    bottom: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiToolTipAnimationVertical(euiTheme.size.base), " ", animationTiming, ";};label:bottom;"),
    left: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiToolTipAnimationHorizontal("-".concat(euiTheme.size.base)), " ", animationTiming, ";};label:left;"),
    right: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", euiToolTipAnimationHorizontal(euiTheme.size.base), " ", animationTiming, ";};label:right;"),
    // Arrow
    euiToolTip__arrow: /*#__PURE__*/(0, _react.css)("content:'';position:absolute;transform-origin:center;border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";background-color:", euiToolTipBackgroundColor(euiTheme, colorMode), ";", (0, _global_styling.logicalSizeCSS)(arrowSize, arrowSize), ";;label:euiToolTip__arrow;"),
    arrowPositions: {
      top: /*#__PURE__*/(0, _react.css)("transform:translateY(", arrowPlusSize, ") rotateZ(45deg);;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)("transform:translateY(", arrowMinusSize, ") rotateZ(45deg);;label:bottom;"),
      left: /*#__PURE__*/(0, _react.css)("transform:translateX(", arrowPlusSize, ") rotateZ(45deg);;label:left;"),
      right: /*#__PURE__*/(0, _react.css)("transform:translateX(", arrowMinusSize, ") rotateZ(45deg);;label:right;")
    },
    // Title
    euiToolTip__title: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.bold, ";", (0, _global_styling.logicalCSS)('border-bottom', "solid ".concat(euiTheme.border.width.thin, " ").concat(euiToolTipBorderColor(euiTheme, colorMode))), " ", (0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.xs), ";;label:euiToolTip__title;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "fzilnk-inlineBlock",
  styles: "display:inline-block;label:inlineBlock;"
} : {
  name: "fzilnk-inlineBlock",
  styles: "display:inline-block;label:inlineBlock;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "14aceuy-block",
  styles: "display:block;label:block;"
} : {
  name: "14aceuy-block",
  styles: "display:block;label:block;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1s3i3p5-euiToolTipAnchor",
  styles: "*[disabled]{pointer-events:none;};label:euiToolTipAnchor;"
} : {
  name: "1s3i3p5-euiToolTipAnchor",
  styles: "*[disabled]{pointer-events:none;};label:euiToolTipAnchor;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiToolTipAnchorStyles = exports.euiToolTipAnchorStyles = function euiToolTipAnchorStyles() {
  return {
    // Elements
    euiToolTipAnchor: _ref3,
    // Variants
    block: _ref2,
    inlineBlock: _ref
  };
};