"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableHeaderCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _icon = require("../icon");
var _inner_text = require("../inner_text");
var _utils = require("./utils");
var _responsive_context = require("./mobile/responsive_context");
var _table_cell_content = require("./_table_cell_content");
var _table_cells_shared = require("./table_cells_shared.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "align", "onSort", "isSorted", "isSortAscending", "className", "scope", "mobileOptions", "width", "style", "readOnly", "description"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var CellContents = function CellContents(_ref) {
  var className = _ref.className,
    align = _ref.align,
    description = _ref.description,
    children = _ref.children,
    canSort = _ref.canSort,
    isSorted = _ref.isSorted,
    isSortAscending = _ref.isSortAscending;
  return (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, {
    className: className,
    align: align,
    textOnly: false,
    truncateText: null
  }, (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTableHeaderCell.titleTextWithDesc",
      default: "{innerText}; {description}",
      values: {
        innerText: innerText,
        description: description
      }
    }, function (titleTextWithDesc) {
      return (0, _react2.jsx)("span", {
        title: description ? titleTextWithDesc : innerText,
        ref: ref,
        className: "eui-textTruncate"
      }, children);
    });
  }), description && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, description)), isSorted ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTableSortIcon",
    type: isSortAscending ? 'sortUp' : 'sortDown',
    size: "m"
  }) : canSort ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTableSortIcon euiTableSortIcon--sortable",
    type: "sortable",
    size: "m",
    color: "subdued" // Tinted a bit further via CSS
  }) : null);
};
var EuiTableHeaderCell = exports.EuiTableHeaderCell = function EuiTableHeaderCell(_ref2) {
  var children = _ref2.children,
    _ref2$align = _ref2.align,
    align = _ref2$align === void 0 ? _services.LEFT_ALIGNMENT : _ref2$align,
    onSort = _ref2.onSort,
    isSorted = _ref2.isSorted,
    isSortAscending = _ref2.isSortAscending,
    className = _ref2.className,
    scope = _ref2.scope,
    mobileOptions = _ref2.mobileOptions,
    width = _ref2.width,
    style = _ref2.style,
    readOnly = _ref2.readOnly,
    description = _ref2.description,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cells_shared.euiTableHeaderFooterCellStyles);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var hideForDesktop = !isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.only);
  var hideForMobile = isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false;
  if (hideForDesktop || hideForMobile) return null;
  var classes = (0, _classnames.default)('euiTableHeaderCell', className);
  var inlineStyles = (0, _utils.resolveWidthAsStyle)(style, width);
  var CellComponent = children ? 'th' : 'td';
  var cellScope = CellComponent === 'th' ? scope !== null && scope !== void 0 ? scope : 'col' : undefined; // `scope` is only valid on `th` elements

  var canSort = !!(onSort && !readOnly);
  var ariaSortValue;
  if (isSorted) {
    ariaSortValue = isSortAscending ? 'ascending' : 'descending';
  } else if (canSort) {
    ariaSortValue = 'none';
  }
  var cellContentsProps = {
    css: styles.euiTableHeaderCell__content,
    align: align,
    description: description,
    canSort: canSort,
    isSorted: isSorted,
    isSortAscending: isSortAscending,
    children: children
  };
  return (0, _react2.jsx)(CellComponent, _extends({
    css: styles.euiTableHeaderCell,
    className: classes,
    scope: cellScope,
    role: "columnheader",
    "aria-sort": ariaSortValue,
    style: inlineStyles
  }, rest), canSort ? (0, _react2.jsx)("button", {
    type: "button",
    css: styles.euiTableHeaderCell__button,
    className: (0, _classnames.default)('euiTableHeaderButton', {
      'euiTableHeaderButton-isSorted': isSorted
    }),
    onClick: onSort,
    "data-test-subj": "tableHeaderSortButton"
  }, (0, _react2.jsx)(CellContents, cellContentsProps)) : (0, _react2.jsx)(CellContents, cellContentsProps));
};
EuiTableHeaderCell.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  align: _propTypes.default.any,
  isSortAscending: _propTypes.default.bool,
  isSorted: _propTypes.default.bool,
  mobileOptions: _propTypes.default.any,
  onSort: _propTypes.default.func,
  scope: _propTypes.default.any,
  width: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  description: _propTypes.default.string,
  /**
       * Shows the sort indicator but removes the button
       */
  readOnly: _propTypes.default.bool
};