"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTableHeaderFooterCellStyles = exports.euiTableCellCheckboxStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _table = require("./table.styles");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiTableHeaderFooterCellStyles = exports.euiTableHeaderFooterCellStyles = function euiTableHeaderFooterCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;

  // euiFontSize returns an object, so we keep object notation here to merge into css``
  var sharedStyles = _objectSpread(_objectSpread({}, (0, _global_styling.euiFontSize)(euiThemeContext, 'xs')), {}, {
    fontWeight: euiTheme.font.weight.semiBold,
    color: euiTheme.colors.title,
    verticalAlign: 'middle'
  });
  return {
    euiTableHeaderCell: /*#__PURE__*/(0, _react.css)(sharedStyles, ";;label:euiTableHeaderCell;"),
    euiTableHeaderCell__content: /*#__PURE__*/(0, _react.css)("gap:", euiTheme.size.xs, ";;label:euiTableHeaderCell__content;"),
    euiTableHeaderCell__button: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), " font-weight:inherit;line-height:inherit;.euiTableSortIcon--sortable{color:", (0, _services.makeHighContrastColor)(
    // Tint it arbitrarily high, the contrast util will take care of lowering back down to WCAG
    (0, _services.tintOrShade)(euiTheme.colors.subduedText, 0.9, colorMode), 3 // 3:1 ratio from https://www.w3.org/WAI/WCAG22/Understanding/non-text-contrast.html
    )(euiTheme.colors.emptyShade), ";}&:hover,&:focus{color:", euiTheme.colors.primaryText, ";text-decoration:underline;.euiTableSortIcon--sortable{color:", euiTheme.colors.primaryText, ";}};label:euiTableHeaderCell__button;"),
    euiTableFooterCell: /*#__PURE__*/(0, _react.css)(sharedStyles, " background-color:", euiTheme.colors.lightestShade, ";;label:euiTableFooterCell;")
  };
};
var euiTableCellCheckboxStyles = exports.euiTableCellCheckboxStyles = function euiTableCellCheckboxStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiTableVariables = (0, _table.euiTableVariables)(euiThemeContext),
    cellContentPadding = _euiTableVariables.cellContentPadding,
    mobileSizes = _euiTableVariables.mobileSizes,
    checkboxSize = _euiTableVariables.checkboxSize;
  var sharedCheckboxStyles = "\n    ".concat((0, _global_styling.logicalCSS)('width', checkboxSize), "\n    vertical-align: middle;\n  ");
  return {
    euiTableHeaderCellCheckbox: /*#__PURE__*/(0, _react.css)(sharedCheckboxStyles, (0, _global_styling.logicalTextAlignCSS)('left'), ";;label:euiTableHeaderCellCheckbox;"),
    euiTableRowCellCheckbox: /*#__PURE__*/(0, _react.css)(sharedCheckboxStyles, ";;label:euiTableRowCellCheckbox;"),
    desktop: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-vertical', euiTheme.border.thin), ";;label:desktop;"),
    mobile: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('top', cellContentPadding), " ", (0, _global_styling.logicalCSS)('left', mobileSizes.checkbox.offset), ";;label:mobile;")
  };
};